CREATE TABLE `feeds` (
  `feed_id` bigint(20) unsigned NOT NULL,
  `ClientID` int(10) NOT NULL,
  `market_business_id` bigint(20) DEFAULT NULL,
  `market_shop_id` bigint(20) DEFAULT NULL,
  `market_feed_id` bigint(20) DEFAULT NULL,
  `feed_type` varchar(32) DEFAULT NULL,
  `business_type` enum('retail','hotels','realty','auto','flights','news','other') NOT NULL DEFAULT 'retail',
  `source` enum('url','file','site') NOT NULL,
  `name` varchar(255) NOT NULL,
  `url` varchar(4096) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `login` varchar(255) DEFAULT NULL,
  `encrypted_password` varbinary(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `refresh_interval` int(10) NOT NULL,
  `is_remove_utm` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `update_status` enum('New','Outdated','Updating','Done','Error') NOT NULL DEFAULT 'New',
  `cached_file_hash` varchar(22) CHARACTER SET latin1 DEFAULT NULL,
  `fetch_errors_count` tinyint(3) NOT NULL DEFAULT '0',
  `offers_count` int(10) DEFAULT NULL,
  `LastChange` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_refreshed` datetime DEFAULT NULL,
  `master_system` enum('direct','market','business_account','manual','shop_in_shop') NOT NULL DEFAULT 'direct',
  `target_domain` varchar(255) DEFAULT NULL,
  `offer_examples` mediumtext,
  `usage_type` set('search_snippet_gallery','goods_ads') DEFAULT NULL,
  `last_used` datetime DEFAULT NULL,
  `statusMbiSynced` enum('Yes','No') NOT NULL DEFAULT 'No',
  `shop_name` varchar(255) DEFAULT NULL,
  `statusMbiEnabled` enum('Yes','No') NOT NULL DEFAULT 'No',
  PRIMARY KEY (`feed_id`),
  KEY `update_status` (`update_status`,`last_refreshed`),
  KEY `lastchange` (`LastChange`),
  KEY `i_market_feed_id` (`market_feed_id`),
  KEY `i_ClientID` (`ClientID`),
  KEY `i_market_business_id_shop_id` (`market_business_id`,`market_shop_id`),
  KEY `i_last_used` (`last_used`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
