CREATE TABLE `mobile_apps` (
  `mobile_app_id` bigint(20) NOT NULL,
  `ClientID` int(10) unsigned NOT NULL,
  `store_type` enum('other','AppleAppStore','GooglePlayStore') NOT NULL DEFAULT 'other',
  `store_href` varchar(1024) NOT NULL DEFAULT '',
  `name` varchar(1024) NOT NULL DEFAULT '',
  `mobile_content_id` bigint(20) unsigned DEFAULT NULL,
  `device_type_targeting` set('phone','tablet') DEFAULT NULL,
  `network_targeting` set('wifi','cell') DEFAULT NULL,
  `min_os_version` varchar(10) DEFAULT NULL,
  `displayed_attributes` set('rating','price','icon','rating_votes') DEFAULT NULL,
  `primary_action` enum('download','get','install','more','open','update','play','buy') DEFAULT NULL,
  `app_metrika_application_id` bigint(20) DEFAULT NULL,
  `domain_id` int(10) unsigned DEFAULT NULL,
  `has_identified_postbacks` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`mobile_app_id`),
  KEY `ClientID` (`ClientID`),
  KEY `mobile_content_id` (`mobile_content_id`),
  KEY `fk_mobile_apps__domain_id` (`domain_id`),
  KEY `has_identified_postbacks` (`has_identified_postbacks`),
  CONSTRAINT `fk_mobile_apps__domain_id` FOREIGN KEY (`domain_id`) REFERENCES `domains` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8

