CREATE TABLE `mod_reasons` (
  `rid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id` bigint(20) unsigned NOT NULL,
  `type` enum('campaign','banner','phrases','contactinfo','media_banner','media_group','sitelinks_set','image','mobile_content','perf_creative','callout','display_href','image_ad','canvas','video_addition','turbolanding','html5_creative','banner_page','banner_logo','banner_button','banner_name','banner_multicard','promo_extension') NOT NULL,
  `ClientID` int(10) unsigned NOT NULL DEFAULT '0',
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `statusSending` enum('Yes','No','Sending') NOT NULL DEFAULT 'No',
  `statusModerate` enum('Yes','No','Sent','New','Old') NOT NULL DEFAULT 'Yes',
  `statusPostModerate` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `timeCreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reason` text,
  `assets_reasons` json DEFAULT NULL,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `idt` (`id`,`type`),
  KEY `i_statusSending_timeCreated` (`statusSending`,`timeCreated`),
  KEY `i_ClientID_cid` (`ClientID`,`cid`),
  KEY `statusModerate` (`statusModerate`,`timeCreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
