CREATE TABLE `optimizing_campaign_requests` (
  `request_id` int(10) unsigned NOT NULL,
  `cid` int(10) unsigned NOT NULL,
  `MediaUID` int(10) unsigned DEFAULT NULL,
  `status` enum('New','InProcess','Declined','Ready','Accepted','AcceptDeclined','Rejected','Converted') DEFAULT 'New',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `comment` text,
  `fio` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `budget` double DEFAULT NULL,
  `ready_time` datetime DEFAULT NULL,
  `accept_time` datetime DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `reject_comment` text,
  `auto_request` enum('No','ModerateYes','ModerateNo','Automatic') DEFAULT 'No',
  `added_banners_count` int(11) NOT NULL,
  `is_easy_user` enum('Yes','No') DEFAULT 'No',
  `request_type` enum('Normal','Support') DEFAULT 'Normal',
  `improvements` set('Text','Settings','AddKeywords','SpecifyKeyword','AddAddress','AddSitelinks') DEFAULT NULL,
  `CreaterUID` int(10) unsigned DEFAULT NULL,
  `postpone_date` datetime DEFAULT NULL,
  `request_comment` varchar(500) DEFAULT NULL,
  `req_type` enum('FirstAid','SecondAid','Moderate') DEFAULT 'FirstAid',
  `is_automatic` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_support` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`request_id`),
  KEY `cid` (`cid`),
  KEY `MediaUID` (`MediaUID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
