CREATE TABLE `pdf_reports` (
  `id` int(10) unsigned NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `cids` text NOT NULL,
  `uid` bigint(20) NOT NULL,
  `status` enum('new','processing','ready') DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `processing_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ready_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `connect_id` int(10) unsigned NOT NULL,
  `pdf_data` mediumblob,
  `date_group` enum('day','week','month','year') NOT NULL DEFAULT 'day',
  `stat_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `rank` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status_no_data` enum('Yes','No') NOT NULL DEFAULT 'No',
  `lang` enum('ru','en') DEFAULT 'ru',
  `phrases_count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `status` (`status`),
  KEY `create_time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
