CREATE TABLE `perf_creatives` (
  `creative_id` bigint(20) unsigned NOT NULL,
  `creative_type` enum('performance','canvas','video_addition','html5_creative','bannerstorage') NOT NULL DEFAULT 'performance',
  `ClientID` int(10) unsigned NOT NULL,
  `stock_creative_id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `width` smallint(5) unsigned DEFAULT NULL,
  `height` smallint(5) unsigned DEFAULT NULL,
  `is_adaptive` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `alt_text` varchar(255) DEFAULT NULL,
  `href` varchar(1024) DEFAULT NULL,
  `preview_url` varchar(1024) NOT NULL,
  `sum_geo` text,
  `statusModerate` enum('New','Ready','Sending','Sent','Yes','No','Error','AdminReject') NOT NULL DEFAULT 'New',
  `moderate_send_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `moderate_try_count` smallint(5) unsigned NOT NULL,
  `template_id` int(10) unsigned DEFAULT NULL,
  `moderate_info` text,
  `is_generated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_brand_lift` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `source_media_type` enum('gif','jpg','png') DEFAULT NULL,
  `business_type` enum('retail','hotels','realty','auto','flights','news','other','pharm') NOT NULL DEFAULT 'retail',
  `theme_id` int(10) unsigned DEFAULT NULL,
  `creative_group_id` int(10) unsigned DEFAULT NULL,
  `group_create_time` datetime DEFAULT NULL,
  `group_name` varchar(255) DEFAULT NULL,
  `layout_id` int(10) unsigned DEFAULT NULL,
  `version` bigint(20) DEFAULT NULL,
  `live_preview_url` varchar(1024) DEFAULT NULL,
  `archive_url` varchar(1024) DEFAULT NULL,
  `yabs_data` json DEFAULT NULL,
  `moderation_comment` text,
  `duration` int(10) DEFAULT NULL,
  `additional_data` json DEFAULT NULL,
  `has_packshot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `expanded_preview_url` varchar(1024) DEFAULT NULL,
  `is_bannerstorage_predeployed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`creative_id`),
  UNIQUE KEY `ClientID_stock_creative_id` (`ClientID`,`stock_creative_id`),
  KEY `statusModerate` (`statusModerate`),
  KEY `moderate_send_time` (`moderate_send_time`),
  KEY `creative_group_id` (`creative_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
