CREATE TABLE `strategies` (
  `strategy_id` int(10) unsigned NOT NULL,
  `ClientID` int(10) unsigned NOT NULL DEFAULT '0',
  `type` enum('default','min_price','no_premium','autobudget','autobudget_media','autobudget_week_bundle','autobudget_avg_click','autobudget_avg_cpa','autobudget_avg_cpa_per_camp','autobudget_avg_cpa_per_filter','autobudget_avg_cpc_per_camp','autobudget_avg_cpc_per_filter','autobudget_avg_cpi','autobudget_roi','cpm_default','autobudget_max_reach','autobudget_max_impressions','autobudget_max_reach_custom_period','autobudget_max_impressions_custom_period','period_fix_bid','autobudget_avg_cpv','autobudget_avg_cpv_custom_period','autobudget_crr','unknown') DEFAULT 'unknown',
  `strategy_data` json NOT NULL,
  `ContextLimit` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `attribution_model` enum('last_click','first_click','last_significant_click','last_yandex_direct_click','first_click_cross_device','last_significant_click_cross_device','last_yandex_direct_click_cross_device','unknown') NOT NULL DEFAULT 'unknown',
  `day_budget` decimal(16,2) unsigned NOT NULL DEFAULT '0.00',
  `day_budget_show_mode` enum('default','stretched') NOT NULL DEFAULT 'default',
  `wallet_cid` int(10) unsigned NOT NULL DEFAULT '0',
  `archived` enum('Yes','No') NOT NULL DEFAULT 'No',
  `day_budget_daily_change_count` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `day_budget_last_change` datetime DEFAULT NULL,
  `enable_cpc_hold` enum('Yes','No') NOT NULL DEFAULT 'No',
  `LastChange` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `name` text,
  `meaningful_goals` json DEFAULT NULL,
  `is_public` enum('Yes','No') NOT NULL DEFAULT 'No',
  PRIMARY KEY (`strategy_id`),
  KEY `ClientID` (`ClientID`),
  KEY `wallet_cid` (`wallet_cid`),
  KEY `is_public` (`is_public`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
