CREATE TABLE `users_options` (
  `uid` bigint(20) NOT NULL,
  `ya_counters` smallint(5) unsigned NOT NULL,
  `statusPostmoderate` enum('No','Yes') DEFAULT 'No',
  `manager_office_id` tinyint(3) unsigned DEFAULT NULL COMMENT 'office of manager (meaningful only for managers)',
  `geo_id` int(10) unsigned NOT NULL,
  `statusEasy` enum('No','Yes') NOT NULL DEFAULT 'No',
  `sendAgencyMcbLetters` enum('No','Yes') NOT NULL DEFAULT 'No' COMMENT 'manager with this flag will recieve copy of all agency mcb letters',
  `sendAgencyDirectLetters` enum('No','Yes') NOT NULL DEFAULT 'No' COMMENT 'manager with this flag will recieve copy of some agency direct letters',
  `options` text COMMENT 'YAML of different user interface options',
  `show_fa_teaser` enum('No','Yes') DEFAULT 'No' COMMENT 'forcibly show first aid teaser to user',
  `sendClientLetters` enum('Yes','No') NOT NULL DEFAULT 'Yes' COMMENT 'send mails to client rep about all campaigns',
  `sendClientSMS` enum('Yes','No') NOT NULL DEFAULT 'Yes' COMMENT 'send SMS to client rep about all campaigns',
  `use_camp_description` enum('No','Yes') NOT NULL DEFAULT 'No',
  `manager_use_crm` enum('No','Yes') NOT NULL DEFAULT 'No',
  `agency_email_to_chief` enum('No','Yes') NOT NULL DEFAULT 'No' COMMENT 'send email copy to agency chief',
  `is_offer_accepted` enum('No','Yes') NOT NULL DEFAULT 'No',
  `passport_karma` tinyint(4) DEFAULT NULL,
  `tags_allowed` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `opts` set('fold_infoblock','notify_about_new_domains','do_not_send_sms') NOT NULL,
  `recommendations_email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
