CREATE TABLE `video_segment_goals` (
  `pid` bigint(20) NOT NULL,
  `audience_type` enum('start','first_quartile','midpoint','third_quartile','complete') NOT NULL,
  `external_audience_status` enum('processed','is_processed','processing_failed','deleted','few_data') DEFAULT NULL,
  `internal_status` enum('new','historical_required','complete') DEFAULT NULL,
  `is_disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `external_audience_id` bigint(20) NOT NULL DEFAULT '0',
  `segment_owner_uid` bigint(20) NOT NULL DEFAULT '0',
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_successful_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `segment_error_count` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`,`audience_type`),
  KEY `internal_status_idx` (`internal_status`),
  KEY `last_successful_update_time_idx` (`last_successful_update_time`),
  KEY `external_audience_id_idx` (`external_audience_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
