CREATE TABLE `api_app_certification_request` (
  `cr_id` int(10) unsigned NOT NULL,
  `application_id` char(32) NOT NULL,
  `name` varchar(500) NOT NULL,
  `uid` bigint(20) unsigned NOT NULL,
  `access_type` enum('test','normal','advanced') NOT NULL DEFAULT 'test',
  `request_info` text NOT NULL,
  `other_info` text,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `end_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` enum('Approve','Reject','New') NOT NULL DEFAULT 'New',
  `check_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment` text,
  `manager_login` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cr_id`),
  UNIQUE KEY `i_uid_application_id` (`application_id`,`uid`),
  KEY `i_uid` (`uid`),
  KEY `i_application_id` (`application_id`),
  KEY `i_create_time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
