CREATE TABLE `cpa_estimates` (
  `attribution_model` enum('last_click','first_click','last_significant_click','last_yandex_direct_click','first_click_cross_device','last_significant_click_cross_device','last_yandex_direct_click_cross_device') NOT NULL DEFAULT 'last_click',
  `business_category` text NOT NULL,
  `business_category_hash` bigint(20) unsigned NOT NULL,
  `region_id` int(10) unsigned NOT NULL,
  `goal_type` enum('url','number','step','action','ecommerce','offline','call','form','email','phone','cdp_order_in_progress','cdp_order_paid','messenger','file','search','button','e_cart','e_purchase','a_cart','a_purchase','conditional_call','social','payment_system','contact_data') NOT NULL DEFAULT 'url',
  `median_cpa` decimal(10,2) NOT NULL,
  `min_cpa` decimal(10,2) NOT NULL,
  `max_cpa` decimal(10,2) NOT NULL,
  PRIMARY KEY (`attribution_model`,`business_category_hash`,`region_id`,`goal_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
