CREATE TABLE `cpm_price_packages` (
  `package_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `tracker_url` text NOT NULL,
  `price` decimal(13,2) NOT NULL,
  `currency` enum('RUB','UAH','KZT','USD','EUR','TRY','CHF','BYN','GBP') NOT NULL DEFAULT 'RUB',
  `order_volume_min` int(10) NOT NULL,
  `order_volume_max` int(10) NOT NULL,
  `price_markups` json DEFAULT NULL,
  `targeting_markups` json DEFAULT NULL,
  `targetings_fixed` json NOT NULL,
  `targetings_custom` json NOT NULL,
  `status_approve` enum('New','Waiting','No','Yes') NOT NULL DEFAULT 'New',
  `last_update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_start` date NOT NULL,
  `date_end` date NOT NULL,
  `is_public` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_special` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_archived` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `available_ad_group_types` set('cpm_yndx_frontpage','cpm_video','cpm_banner','cpm_audio') NOT NULL DEFAULT '',
  `is_campaign_auto_approve` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_draft_approve_allowed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `allowed_page_ids` json DEFAULT NULL,
  `allowed_target_tags` json DEFAULT NULL,
  `allowed_order_tags` json DEFAULT NULL,
  `allowed_project_param_conditions` json DEFAULT NULL,
  `campaign_options` json DEFAULT NULL,
  `bid_modifiers` json DEFAULT NULL,
  `allowed_creative_templates` json DEFAULT NULL,
  `ProductID` int(10) DEFAULT NULL,
  `allowed_ssp` json DEFAULT NULL,
  `allowed_domains` json DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `auction_priority` int(10) DEFAULT NULL,
  `is_cpd` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_frontpage` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`package_id`),
  KEY `status_approve` (`status_approve`),
  KEY `category_id` (`category_id`),
  KEY `is_cpd` (`is_cpd`),
  KEY `is_frontpage` (`is_frontpage`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
