CREATE TABLE `crypta_goals` (
  `goal_id` bigint(20) NOT NULL,
  `parent_goal_id` bigint(20) DEFAULT NULL,
  `name` text,
  `crypta_goal_type` enum('social_demo','family','interests','behaviors','audio_genres','brandsafety','internal','content_category','content_genre','host') NOT NULL,
  `tanker_name_key` text,
  `tanker_description_key` text,
  `interest_type` enum('short-term','long-term','all') NOT NULL,
  `tags` text,
  `bb_keyword` text,
  `bb_keyword_value` text,
  `bb_keyword_short` text,
  `bb_keyword_value_short` text,
  `scope` set('common','internal_ad','custom_audience','media','performance') NOT NULL DEFAULT '',
  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `campaign_type` set('media','performance') NOT NULL DEFAULT '',
  `tanker_audience_type_key` text,
  PRIMARY KEY (`goal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
