CREATE TABLE `dbqueue_job_archive` (
  `job_id` bigint(20) unsigned NOT NULL,
  `ClientID` int(10) unsigned NOT NULL,
  `job_type_id` int(10) unsigned NOT NULL,
  `namespace` varchar(20) DEFAULT NULL,
  `status` enum('Finished','Failed','Revoked') NOT NULL,
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `args` mediumblob,
  `priority` int(11) NOT NULL DEFAULT '0',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expiration_time` datetime DEFAULT NULL,
  `grabbed_by` varchar(100) NOT NULL DEFAULT '',
  `grabbed_until` datetime DEFAULT NULL,
  `grabbed_at` datetime DEFAULT NULL,
  `trycount` int(11) NOT NULL DEFAULT '0',
  `run_after` datetime DEFAULT NULL,
  `result` mediumblob,
  PRIMARY KEY (`job_id`),
  KEY `i_client_jobs` (`ClientID`,`job_type_id`,`status`),
  KEY `i_job_type_id` (`job_type_id`),
  CONSTRAINT `fk_dbqueue_job_archive__job_type_id` FOREIGN KEY (`job_type_id`) REFERENCES `dbqueue_job_types` (`job_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
