CREATE TABLE `deals_adfox` (
  `deal_id` bigint(20) NOT NULL,
  `ClientID` int(10) unsigned DEFAULT NULL,
  `create_time_utc` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `adfox_deal_status` enum('Created','Active','Closed') NOT NULL DEFAULT 'Created',
  `deal_type` enum('preferred_deal','private_marketplace') NOT NULL,
  `publisher_name` text,
  `adfox_name` text NOT NULL,
  `adfox_description` text,
  `date_start_utc` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_end_utc` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `contacts` text,
  `targetings` text,
  `currency_iso_code` int(10) DEFAULT NULL,
  `expected_impressions_per_week` bigint(20) NOT NULL DEFAULT '0',
  `expected_money_per_week` bigint(20) NOT NULL DEFAULT '0',
  `cpm` decimal(12,2) NOT NULL,
  `margin_ratio` decimal(8,2) unsigned DEFAULT NULL,
  `agency_revenue_ratio` decimal(8,2) unsigned DEFAULT NULL,
  `agency_revenue_type` int(10) DEFAULT NULL,
  `placements` json DEFAULT NULL,
  `misc_attrs_json` text NOT NULL,
  PRIMARY KEY (`deal_id`),
  KEY `idx_deals_adfox_ClientID` (`ClientID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
