CREATE TABLE `oneshot_launch_data` (
  `launch_data_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `launch_id` bigint(20) NOT NULL,
  `shard` tinyint(3) NOT NULL DEFAULT '0',
  `span_id` bigint(20) NOT NULL,
  `launch_time` timestamp NULL DEFAULT NULL,
  `last_active_time` timestamp NULL DEFAULT NULL,
  `launched_revisions` varchar(500) DEFAULT NULL,
  `launch_status` enum('ready','in_progress','failed','paused','canceled','done','pause_requested') NOT NULL DEFAULT 'ready',
  `state` json DEFAULT NULL,
  `finish_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`launch_data_id`),
  UNIQUE KEY `unique_launch_id_shard` (`launch_id`,`shard`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
