#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'manual',
      when => 'after',
      time_estimate => '1 час',
      instructions => 'запускать по просьбе santama@',
      when => 'instructions',
      text => 'https://st.yandex-team.ru/DIRECT-81660: Обойти картинки баннеров через аватарницу
        Количество обновляемых картинок ~ 260_000, см. https://yt.yandex-team.ru/hahn/?page=navigation&path=//home/direct/test/santama/smart_crop&offsetMode=row
      ',
    }
  ],
  approved_by => 'zhur'
}

=cut


use my_inc '..';
use Direct::Modern;

use ScriptHelper;
use Settings;
use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::HashUtils qw/hash_cut/;
use Yandex::ListUtils qw/chunks/;
use Yandex::Retry qw/relaxed_guard/;
use Yandex::YT::Table;
use Tools;


$Yandex::YT::Streaming::DEFAULT_FORMAT = 'json';

my $offset     = 0;
my $limit      = 0;
my $relaxed    = 10;
my $yt_cluster = 'hahn';
my $chunk_size = 1000;
my $yt_table   = '//home/direct/test/santama/smart_crop';

my $update_only_formats = 0;

$log->out('START');

extract_script_params(
    'offset=i'      => \$offset,
    'limit=i'       => \$limit,
    'cluster=s'     => \$yt_cluster,
    'table=s'       => \$yt_table,
    'chunksize=i'   => \$chunk_size,
    'relaxed=s'     => \$relaxed,
    'formats'       => \$update_only_formats,
);

my $total_images_updated = 0;

if ($limit) {
    $log->out( sprintf( 'limit on images amount is given - %s' => $limit ) );
}

if ($offset) {
    $log->out( sprintf( 'offset is given - %s' => $offset ) );
}

Tools::force_set_yt_environment($yt_cluster);

my $table = Yandex::YT::Table->new($yt_table);
unless ($table->exists()) {
    $log->die("table $yt_table doesn't exists");
}

my @image_list_buffer;
my $end_row_num = $limit > 0 ? '#' . ($offset + $limit) : '';
my $reader = $table->reader(undef, "[#$offset:${end_row_num}]", format => "json");
while ( my $r = $reader->next() ) {

    push @image_list_buffer, $r;

    if ( @image_list_buffer >= $chunk_size ) {
        proccess_images( \@image_list_buffer );
        @image_list_buffer = ();
    }

}

if ( @image_list_buffer ) {
    proccess_images( \@image_list_buffer );
}

$log->out('FINISH');

sub proccess_images {
    my $images = shift;

    my %sharded_images;
    for (@$images) {
        push @{ $sharded_images{$_->{shard}} }, $_;
    }
    foreach_shard shard => [keys %sharded_images], sub {
            my ($shard) = @_;

            my @shard_images = @{ $sharded_images{$shard} };

            my $rg = relaxed_guard times => $relaxed;

            my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

            $log->out( sprintf('%s images to update', scalar(@shard_images) ) );

            update_banner_images_formats( $shard, \@shard_images );

        };
    $log->out( sprintf( '%s banner_images_formats rows updated so far' => $total_images_updated ) );
}

$log->out( sprintf( 'total %s banner_images_formats rows updated' => $total_images_updated ) );
$log->out('FINISH');


sub update_banner_images_formats {
    my ( $shard, $images ) = @_;

    my $size = scalar @$images;

    return unless $size;

    $log->out({'update_images_formats' => [ map { hash_cut($_, qw/image_hash/) } @$images ]});
    my %image_hash_to_mds_meta = map {$_->{image_hash} => $update_only_formats ? { formats => $_->{formats} } : { mds_meta => $_->{mds_meta} }} @$images;

    my $res = do_mass_update_sql(PPC(shard => $shard), 'banner_images_formats', 'image_hash', \%image_hash_to_mds_meta);

    $total_images_updated += $res;
}

