#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
      comment => "скрипт можно перезапускать"
    }
  ],
  approved_by => 'ppalex'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;

extract_script_params(
    'shard=i' => \my $only_shard
);

$log->out('START');

foreach my $shard (ppc_shards()) {

    if ($only_shard && $only_shard ne $shard) {
        next;
    }
    $log->msg_prefix("[shard $shard]");
    $log->out("process shard $shard");

    my $rows_to_delete = get_all_sql(PPC(shard => $shard), 'SELECT ctb.cid, ctb.OrderID, ctb.create_time
        FROM campaigns_orderid_to_be ctb
        LEFT JOIN campaigns c ON ctb.cid=c.cid
        WHERE c.cid IS NULL');

    if (@$rows_to_delete) {
        $log->out("rows_to_delete:", $rows_to_delete);
        my $cids_to_delete = [ map { $_->{cid} } @$rows_to_delete ];
        my $count = do_delete_from_table(PPC(shard => $shard), 'campaigns_orderid_to_be', where => {cid => $cids_to_delete}) + 0;
        $log->out("deleted $count rows");
    }
}
$log->out('FINISH');
