#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'hrustyashko',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1-2 минуты на шард",
      comment => "скрипт можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DateTime qw/mysql2iso8601/;
use Yandex::Retry qw/relaxed_guard/;

use my_inc '..';
use Settings;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use EnvTools qw/is_beta/;

my $DATE_TIME = '2019-12-20 00:00:00';
my $SLEEP_COEF = 0.3;
my $timezone = DateTime::TimeZone->new(name=>'local');

extract_script_params(
    'shard=i' => \my $only_shard,
    'date-time=i' => \$DATE_TIME,
    'pid=i@' => \my @only_pids,
);

$log->out('START');

if (!is_beta()) {
  if (@only_pids) {
    $log->die("--pid is beta only!");
  }
}

foreach my $shard (ppc_shards()) {
  if ($only_shard && $only_shard ne $shard) {
    next;
  }
  $log->msg_prefix("[shard $shard]");
  $log->out("process shard $shard");

  my $segments_to_update = get_all_sql(PPC(shard => $shard), [
      'SELECT vsg.pid, vsg.audience_type, vsg.time_created, vsg.last_successful_update_time FROM video_segment_goals vsg
      JOIN phrases p on p.pid = vsg.pid',
      where => {
          'p.adgroup_type' => ['cpm_audio', 'cpm_video'],
          'vsg.audience_type__ne' => 'start',
          'vsg.is_disabled' => 0,
          'vsg.external_audience_id__ne' => 0,
          'vsg.external_audience_status__ne' => 'deleted',
          (@only_pids ? ('vsg.pid' => \@only_pids) : ()),
      }
  ]);
  $log->out(sprintf("%d rows selected", scalar @$segments_to_update));

  for my $segment (@$segments_to_update) {
    my $relax = relaxed_guard(times => $SLEEP_COEF);
    $log->out("processing adgroup $segment->{pid}, audience_type $segment->{audience_type} with time_created $segment->{time_created}");
    my $target_date;

    if (mysql2iso8601($segment->{last_successful_update_time}, $timezone) le mysql2iso8601($DATE_TIME, $timezone)) {
      $log->out("skipping adgroup $segment->{pid}, audience_type $segment->{audience_type} with last_successful_update_time $segment->{last_successful_update_time}");
      next;
    }

    if (mysql2iso8601($segment->{time_created}, $timezone) lt mysql2iso8601($DATE_TIME, $timezone) ) {
      $target_date = $DATE_TIME;
    } else {
      $target_date = $segment->{time_created};
    }
    $log->out("updating adgroup $segment->{pid}, audience_type $segment->{audience_type} with date $target_date");
    do_update_table(PPC(shard => $shard), 'video_segment_goals',
        { last_successful_update_time => $target_date },
        where => {
            pid           => $segment->{pid},
            audience_type => $segment->{audience_type},
        });
  }
}
$log->out('FINISH');
