#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "10 минут на всех шардах на dev7",
      comment => "можно перезапускать"
    }
  ],
  approved_by => 'gerdler'
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use Settings;
use Yandex::Retry qw/relaxed/;

use BS::ResyncQueue;

my $SELECT_CHUNK_SIZE = 100000;
my $EDIT_CHUNK_SIZE = 10000;

$log->out('START');

for my $shard (ppc_shards()) {

	my %resync_data_to_send;
	my %delete_additions_item_hash;
	my $last_bid = 0;
	my $last_additions_item_id = 0;

    while(1) {
        my $pref_guard = $log->msg_prefix_guard( "[shard $shard]" );
		my $chunk = get_all_sql(PPC(shard => $shard),
	        "SELECT ba.*, b.cid
	         FROM banners_additions ba
	         	JOIN banners b ON ba.bid = b.bid
	         WHERE ba.additions_item_id IN (
	         	SELECT aic.additions_item_id
	         	FROM additions_item_callouts aic
	         	WHERE aic.is_deleted = 1
	         		AND aic.additions_item_id = ba.additions_item_id
	         )
	         AND (
	         	ba.bid > ?
	         	OR (
	         		ba.bid = ?
	         		AND ba.additions_item_id > ?
	         	)
	         )
	         ORDER BY ba.bid, ba.additions_item_id
	         LIMIT ?", $last_bid, $last_bid, $last_additions_item_id, $SELECT_CHUNK_SIZE);

		$last_additions_item_id = 0;
		if( @$chunk ) {
 			for my $row (@$chunk) {
				$resync_data_to_send{$row->{bid}} = $row->{cid};

				push @{$delete_additions_item_hash{$row->{additions_item_id}}}, $row;

 				if ( $last_bid < $row->{bid} ) {
 					$last_bid = $row->{bid};
 					$last_additions_item_id = 0;
 				} else {
 					$last_additions_item_id = $row->{additions_item_id};
 				}
 			}
		}

        last if @$chunk != $SELECT_CHUNK_SIZE;
	}

	my @delete_additions_item_ids = keys %delete_additions_item_hash;
	if ( @delete_additions_item_ids > 0 ) {
		for my $chunk_additions_item_ids (chunks(\@delete_additions_item_ids, $EDIT_CHUNK_SIZE)) {
			relaxed times => 1, sub {
		        my $deleted = do_sql(PPC(shard => $shard), [
		        	"DELETE ba FROM banners_additions ba LEFT JOIN additions_item_callouts aic ON ba.additions_item_id = aic.additions_item_id",
		        	WHERE => {"ba.additions_item_id" => \@$chunk_additions_item_ids, "aic.is_deleted" => 1}]);
		        for my $additions_item_id ( @$chunk_additions_item_ids ) {
		        	for my $rows ( $delete_additions_item_hash{$additions_item_id} ) {
		        		for my $row ( @$rows ) {
				        	delete $row->{cid};
			            	$log->out({ message => 'deleted', row => $row });
		            	}
	            	}
		        }
		        $log->out("deleted $deleted rows");
	    	};
	    }
	}

	if ( keys %resync_data_to_send > 0 ) {
		my @resync_data;
		foreach my $bid (keys %resync_data_to_send) {
			push @resync_data, {bid => $bid, cid => $resync_data_to_send{$bid}, priority => BS::ResyncQueue::PRIORITY_UPDATE_BANNER_WITH_ADDITIONS};
		}
		
		for my $chunk_resync_data (chunks(\@resync_data, $EDIT_CHUNK_SIZE)) {
			relaxed times => 1, sub {
				$log->out("send chunk of ".@$chunk_resync_data." bids to bs_resync");
				BS::ResyncQueue::bs_resync($chunk_resync_data);
			}
		}
	}
}

$log->out('FINISH');

