#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'hrustyashko',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "8 секунд на все шарды",
      comment => "скрипт можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';
use Settings;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;
my $only_shard;
extract_script_params(
    'shard=i' => \$only_shard
);

$log->out('START');

my @measurers = qw/admetrica adloox adriver dv integral_ad_science mediascope moat sizmek weborama/;
my @feature_types = qw/cpm_geoproduct cpm_video cpm_banner cpm_deals cpm_yndx_frontpage cpm_audio cpm_price/;

my @all_features = map {
        my $system = $_;
        map { $system . "_measurer_" . $_ } @feature_types
} @measurers;

my $features_ids = get_one_column_sql(PPCDICT, ['SELECT feature_id FROM features', WHERE => {feature_text_id => \@all_features}]);

foreach my $shard (ppc_shards()) {
  if ($only_shard && $only_shard ne $shard) {
    next;
  }

  $log->msg_prefix("[shard $shard]");

  my $features = get_all_sql(PPC(shard=>$shard), ['SELECT ClientID, feature_id, is_enabled FROM clients_features', where=>{feature_id => $features_ids}]);

  my $log_str = join "\n", map { sprintf("ClientID: %d, feature_id: %d, is_enabled: %d", 
                                     $_->{ClientID}, $_->{feature_id}, $_->{is_enabled})
                           } @$features;

  if (scalar @$features) {
    $log->out('Prepare for deleting from clients_features: ' . $log_str);
    do_delete_from_table(PPC(shard=>$shard), 'clients_features', where => {feature_id => $features_ids});
    $log->out('Deleting (clients_features) is finished'); 
  } else {
    $log->out('Nothing to delete'); 
  }
}

my $log_str = join "\n", @all_features;
$log->out('Prepare for deleting from features: ' . $log_str);
do_delete_from_table(PPCDICT, 'features', where => {feature_id => $features_ids});

$log->out('FINISH');
