#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "меньше минуты",
      comment => "можно перезапускать"
    }
  ],
  approved_by => 'sco76'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use Currencies;
use ScriptHelper;
use Settings;

# данные получены запросом https://yql.yandex-team.ru/Operations/XkJr6FPzVAHecqAbqx3d7tfpkm8fembptC8_YxrVUz4=
# cid, pid, id, currency
my $to_fix = [
    [33773323, 3246023296, 13358486120, 'RUB'],
    [33773323, 3246023296, 13358486121, 'RUB'],
    [33773323, 3246023296, 13358486122, 'RUB'],
    [35655248, 3379638224, 13626584765, 'RUB'],
    [35659214, 3379932646, 13617576059, 'RUB'],
    [35659214, 3379932646, 13617576061, 'RUB'],
    [34736319, 3318790121, 13219529998, 'RUB'],
    [34736319, 3318790121, 13219530011, 'RUB'],
    [31904369, 3087451402, 14065591973, 'RUB'],
    [31842130, 3096773092, 14982795681, 'RUB'],
    [31842130, 3096773092, 14982795682, 'RUB'],
    [31842130, 3096848172, 14982795522, 'RUB'],
    [31842130, 3096848172, 14982795523, 'RUB'],
    [36000182, 3404626370, 13834720509, 'RUB'],
    [36000182, 3404626370, 13834720512, 'RUB'],
    [35040238, 3337806516, 13362593606, 'RUB'],
    [35040238, 3337806516, 13362593608, 'RUB'],
    [35040238, 3337806516, 13362593610, 'RUB'],
    [38934206, 3580081352, 15915218038, 'RUB'],
    [38934206, 3580081352, 15915218047, 'RUB'],
    [38934206, 3580081352, 15915218051, 'RUB'],
    [38934206, 3580081352, 15915218053, 'RUB'],
    [38934206, 3580081352, 15915218059, 'RUB'],
    [38934206, 3580081352, 15915218061, 'RUB'],
    [38934206, 3580081352, 15915218068, 'RUB'],
    [38934206, 3580081352, 15915218069, 'RUB'],
    [38934206, 3580081352, 15915218070, 'RUB'],
    [38934206, 3580081352, 15915218075, 'RUB'],
    [29480693, 2881947327, 17062446998, 'RUB'],
    [29480693, 2881947327, 17062446999, 'RUB'],
    [29480693, 2881947327, 17062447000, 'RUB'],
    [29480693, 2881947327, 17062447002, 'RUB'],
    [29480693, 2881947327, 17062447003, 'RUB'],
    [29480693, 2881947327, 17062447004, 'RUB'],
    [27237678, 3359185011, 13466897433, 'RUB'],
    [27237678, 3359185011, 13466897435, 'RUB'],
    [36977584, 3470959659, 14257981290, 'BYN'],
    [36977584, 3470959659, 14257981297, 'BYN'],
    [36977584, 3470959659, 14257981298, 'BYN'],
    [36977584, 3470959659, 14257981299, 'BYN'],
    [36977584, 3470959659, 14257981301, 'BYN'],
    [36977584, 3470959659, 14257981302, 'BYN'],
    [36977584, 3470959659, 14257981306, 'BYN'],
    [36977584, 3470959659, 14257981311, 'BYN'],
    [36977584, 3470959659, 14257981312, 'BYN'],
    [36977584, 3470959659, 14257981314, 'BYN'],
    [36977584, 3470959659, 14257981315, 'BYN'],
    [36977584, 3470959659, 14257981320, 'BYN'],
    [36977584, 3470959659, 14257981321, 'BYN'],
    [36977584, 3470959659, 14257981322, 'BYN'],
    [36977584, 3470959659, 14257981323, 'BYN'],
    [36977584, 3470959659, 14257981324, 'BYN'],
    [36977584, 3470959659, 14257981326, 'BYN'],
    [36977584, 3470959659, 14257981327, 'BYN'],
    [36977584, 3470959659, 14257981328, 'BYN'],
    [36977584, 3470959659, 14257981329, 'BYN'],
    [36977584, 3470959659, 14257981331, 'BYN'],
    [36977584, 3470959659, 14257981333, 'BYN'],
    [36977584, 3470959659, 14257981334, 'BYN'],
    [36977584, 3470959659, 14257981335, 'BYN'],
    [34593286, 3308145041, 15583726163, 'RUB'],
    [34629978, 3310616639, 13245889064, 'RUB'],
    [34629978, 3310616639, 13245889066, 'RUB'],
    [34629978, 3310616639, 13245889067, 'RUB'],
    [36368819, 3430228287, 14018913080, 'BYN'],
    [36368819, 3430228287, 14018913089, 'BYN'],
    [36368819, 3430228287, 14018913102, 'BYN'],
    [36368819, 3430228287, 14018913114, 'BYN'],
    [36368819, 3430228287, 14018913117, 'BYN'],
    [36368819, 3430228287, 14018913121, 'BYN'],
    [36393501, 3431670534, 14014005563, 'BYN'],
    [30107168, 2936878223, 15843666941, 'RUB'],
    [30107168, 2936878223, 15843666942, 'RUB'],
    [30107168, 2936878223, 15843666946, 'RUB'],
    [30107168, 2936878223, 15843666947, 'RUB'],
    [30107168, 2936878223, 15843666948, 'RUB'],
    [30107168, 2936878223, 15843666949, 'RUB'],
    [30107168, 2936878223, 15843666950, 'RUB'],
    [30107168, 2936878223, 15843666955, 'RUB'],
    [30107168, 2936878223, 15843666958, 'RUB'],
    [34365706, 3291308706, 13222658219, 'RUB'],
    [34938279, 3331436020, 13321072046, 'RUB'],
    [34938279, 3331436020, 13321072052, 'RUB'],
    [31300891, 3035363129, 14895004001, 'EUR'],
    [30511113, 2971109701, 14425380977, 'RUB'],
    [36828928, 3461423979, 14253751366, 'BYN'],
    [36828928, 3461423979, 14253751373, 'BYN'],
    [36828928, 3461423979, 14253751374, 'BYN'],
    [36828928, 3461423979, 14253751375, 'BYN'],
    [36828928, 3461423979, 14253751377, 'BYN'],
    [36828928, 3461423979, 14253751378, 'BYN'],
    [36828928, 3461423979, 14253751382, 'BYN'],
    [36828928, 3461423979, 14253751387, 'BYN'],
    [36828928, 3461423979, 14253751388, 'BYN'],
    [36828928, 3461423979, 14253751390, 'BYN'],
    [36828928, 3461423979, 14253751391, 'BYN'],
    [36828928, 3461423979, 14253751396, 'BYN'],
    [36828928, 3461423979, 14253751397, 'BYN'],
    [36828928, 3461423979, 14253751398, 'BYN'],
    [36828928, 3461423979, 14253751399, 'BYN'],
    [36828928, 3461423979, 14253751400, 'BYN'],
    [36828928, 3461423979, 14253751402, 'BYN'],
    [36828928, 3461423979, 14253751403, 'BYN'],
    [36828928, 3461423979, 14253751404, 'BYN'],
    [36828928, 3461423979, 14253751405, 'BYN'],
    [36828928, 3461423979, 14253751407, 'BYN'],
    [36828928, 3461423979, 14253751409, 'BYN'],
    [36828928, 3461423979, 14253751410, 'BYN'],
    [36828928, 3461423979, 14253751411, 'BYN'],
    [36904356, 3466391401, 14254210300, 'RUB'],
    [32299689, 3126939951, 16893906069, 'RUB'],
];

$log->out('START');

foreach my $row (@$to_fix) {
    my ($cid, $pid, $id, $currency) = @$row;
    my $max_price = get_currency_constant($currency, 'MAX_PRICE');

    my $bids_arc_id2prices = get_hashes_hash_sql(PPC(cid => $cid), ["select id, price, price_context from bids_arc",
        where => {
            cid => $cid,
            pid => $pid,
            id => $id,
            _OR => {
                price__gt => $max_price,
                price_context__gt => $max_price,
            }
        }]);
    if (%$bids_arc_id2prices) {
        $log->out({bids_arc => {cid => $cid, pid => $pid, id => $id, price => $bids_arc_id2prices->{$id}->{price}, price_context => $bids_arc_id2prices->{$id}->{price_context}}});
        do_update_table(PPC(cid => $cid), 'bids_arc', {price => $max_price, statusBsSynced => 'No'}, where => {cid => $cid, pid => $pid, id => $id, price__gt => $max_price});
        do_update_table(PPC(cid => $cid), 'bids_arc', {price_context => $max_price, statusBsSynced => 'No'}, where => {cid => $cid, pid => $pid, id => $id, price_context__gt => $max_price});
    }

    my $bids_id2prices = get_hashes_hash_sql(PPC(cid => $cid), ["select id, price, price_context from bids",
        where => {
            id => $id,
            _OR => {
                price__gt => $max_price,
                price_context__gt => $max_price,
            }
        }]);
    if (%$bids_id2prices) {
        $log->out({bids => {cid => $cid, pid => $pid, id => $id, price => $bids_id2prices->{$id}->{price}, price_context => $bids_id2prices->{$id}->{price_context}}});
        do_in_transaction {
            do_update_table(PPC(cid => $cid), "bids", {price => $max_price}, where => {id => $id, price__gt => $max_price});
            do_update_table(PPC(cid => $cid), "bids_base", {price => $max_price} , where => {bid_id => $id, price__gt => $max_price});
        };
        do_in_transaction {
            do_update_table(PPC(cid => $cid), "bids", {price_context => $max_price, statusBsSynced => 'No'}, where => {id => $id, price_context__gt => $max_price});
            do_update_table(PPC(cid => $cid), "bids_base", {price_context => $max_price, statusBsSynced => 'No'}, where => {bid_id => $id, price_context__gt => $max_price});
        };
    }
}

$log->out('FINISH');
