#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'sql',
      db => "ppc:all",
      when => 'before',
      time_estimate => "4 sec на все шарды",
      comment => 'применять dbs-guard',
      sql => "ALTER TABLE campaigns_cpm_yndx_frontpage MODIFY `allowed_frontpage_types` set('frontpage','frontpage_mobile', 'browser_new_tab') NOT NULL DEFAULT '', lock=none, algorithm=inplace"
    },
    {
      type => 'sql',
      db => "ppcdict",
      when => 'before',
      time_estimate => "1 sec",
      sql => "ALTER TABLE cpm_yndx_frontpage_min_bids MODIFY `frontpage_type` enum('frontpage','frontpage_mobile','browser_new_tab') NOT NULL DEFAULT 'frontpage', lock=none, algorithm=inplace"
    },  
    {
      type => 'script',
      when => 'after',
      time_estimate => "10 минут на всех шардах на dev7",
      comment => "можно перезапускать, но только скрипт, не всю миграцию."
    }
  ],
  approved_by => 'hrustyashko'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

$log->out('START');

my $min_bids = get_all_sql(PPCDICT, ["SELECT currency, region_id, min_bid FROM cpm_yndx_frontpage_min_bids", where => {frontpage_type=>'frontpage'}]);
my @values = map {[$_->{currency}, $_->{region_id}, $_->{min_bid}, 'browser_new_tab']} @$min_bids;
if (@values) {
    my $sql = "INSERT INTO cpm_yndx_frontpage_min_bids (currency, region_id, min_bid, frontpage_type) VALUES %s ON DUPLICATE KEY UPDATE min_bid=VALUES(min_bid)";

    my $result = do_mass_insert_sql(PPCDICT, $sql, \@values);
    if ($result != scalar(@values)) {
        # Если по какой-то причине (например, сработал on duplicate key) добавились не все цены - надо написать в лог.
        $log->out(sprintf("Tried add %d rows, but added %d rows. Please, check! I can be duplicate case.", scalar(@values), $result));
        my $str = join "; ", map {sprintf("currency: %s, region_id: %d, min_bid: %f", $_->{currency}, $_->{region_id}, $_->{min_bid})} @values;
        $log->out($str);
    } else {
        $log->out(sprintf("Added %d rows as expected!", $result));  
    }
}

$log->out('FINISH');
