#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
      comment => "можно перезапускать, применять в Песочнице не нужно"
    }
  ],
  approved_by => 'ppalex'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

my $wrong_client_id = 366188;
my $correct_client_id = 34235683;
my $cids = [227380, 227807, 227823];
my $shard = 4;

$log->out('START');

$log->out("fix PPCDICT");
my $bid_updated = do_update_table(PPCDICT, 'shard_inc_bid', {ClientID => $correct_client_id},
    where => {
        bid => [301167, 301908, 325787, 389908],
        ClientID => $wrong_client_id,
    }) + 0;
$log->out("shard_inc_bid: bids updated $bid_updated");

my $pid_updated = do_update_table(PPCDICT, 'shard_inc_pid', {ClientID => $correct_client_id},
    where => {
        pid => [300707,301448,325324,389441],
        ClientID => $wrong_client_id,
    }) + 0;
$log->out("shard_inc_pid: pids updated $pid_updated");

my $cid_updated = do_update_table(PPCDICT, 'shard_inc_cid', {ClientID => $correct_client_id},
    where => {
        cid => $cids,
        ClientID => $wrong_client_id,
    }) + 0;
$log->out("shard_inc_cid: cids updated $cid_updated");

my $orderid_updated = do_update_table(PPCDICT, 'shard_order_id', {ClientID => $correct_client_id},
    where => {
        OrderID => [84828, 147921, 149680],
        ClientID => $wrong_client_id,
    }) + 0;
$log->out("shard_order_id: OrderID updated $orderid_updated");

$log->out("fix PPC");
my $camps_updated = do_update_table(PPC(shard => $shard), 'campaigns', {ClientID => $correct_client_id},
    where => {
        cid => $cids,
        ClientID => $wrong_client_id,
    }) + 0;

$log->out("campaigns: camps updated $camps_updated");

$log->out("Create ClientID - shard record in PPCDICT");
do_insert_into_table(PPCDICT, 'shard_client_id', {ClientID => $correct_client_id, shard => $shard}, ignore => 1);

$log->out('FINISH');

