#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'sco76',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "15 минут",
      comment => "Cкрипт можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use JSON;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;

use List::MoreUtils qw/any/;

my $type2values = {
    dynamic => {
        key => 'dyn_cond:from_tab',
        table => 'bids_dynamic',
        id => 'dyn_id',
    },
    performance => {
        key => 'perf_filter:from_tab',
        table => 'bids_performance',
        id => 'perf_filter_id',
    },
};

# по умолчанию обрабатываем смарт-кампании
my $camp_type = 'performance';

extract_script_params(
    'shard=i' => \my $only_shard,
    'camp-type=s' => \$camp_type,
);
unless (defined $camp_type && any {$camp_type eq $_} qw/dynamic performance/) {
    $log->die("camp-type param must be dynamic or performance!");
}


$log->out('START');

$log->out("process $camp_type campaigns");
foreach my $shard (ppc_shards()) {
    if ($only_shard && $only_shard != $shard) {
        next;
    }

    my $log_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
    my $conditions_from_tab_json = get_hash_sql(PPC(shard => $shard), [
        "SELECT c.cid, cso.options FROM campaigns c join camp_secondary_options cso on cso.cid=c.cid", 
        WHERE => {
            'c.type' => $camp_type,
            'cso.key' => $type2values->{$camp_type}->{key},
        },
    ]);
    my $conditions_count = scalar keys %$conditions_from_tab_json;
    $log->out("got $conditions_count $type2values->{$camp_type}->{key} conditions from camp_secondary_options");

    foreach my $cid (keys %$conditions_from_tab_json) {
        my $log_prefix_guard = $log->msg_prefix_guard("[shard $shard, cid $cid]");
        my $conditions_from_tab = eval { decode_json($conditions_from_tab_json->{$cid}) };
        if (!defined $conditions_from_tab || $@) {
            $log->out("Can't decode JSON, campaign has not been processed");
            next;
        }

        my $from_tab_values = {};
        $from_tab_values->{$_} = { from_tab => $conditions_from_tab->{$_} } for keys %$conditions_from_tab;
        my $affected_rows = do_mass_update_sql(PPC(shard => $shard), $type2values->{$camp_type}->{table}, $type2values->{$camp_type}->{id}, $from_tab_values);
        $log->out("Updated $affected_rows records in $type2values->{$camp_type}->{table}");
    }

}

$log->out('FINISH');

