#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'elwood',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько минут",
      comment => "Можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils; 

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard $shard]");
    my $turbos = get_one_column_sql(PPC(shard => $shard), ["SELECT bid FROM banner_turbolandings", where => { statusModerate => 'Ready'}]);
    if (@$turbos) {
        for my $chunk (Yandex::ListUtils::chunks($turbos, 1000)) {
            $log->out("Update statusModerate on turbos:", $chunk);

            do_update_table(PPC(shard => $shard), 'banner_turbolandings', {statusModerate => 'Sent'}, 
                where => {bid => $chunk, statusModerate => 'Ready'});

            do_update_table(PPC(shard => $shard), 'banner_turbolandings', {statusModerate => 'Ready'}, 
                where => {bid => $chunk});
        }
    } else {
        $log->out("No turbos with wrong statusModerate");
    }

}

$log->out('FINISH');

