#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "10s",
      comment => "Можно перезапускать. Данные надо привезти с ppcdev2, например:
            scp ppcdev2:/opt/ppc-data/20200722_fill_historic_promocode_domains.data .
            путь к этому файлу нужно будет указать в параметрах запуска,
            ./20200722_fill_historic_promocode_domains.pl --data-file=20200722_fill_historic_promocode_domains.data"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use Path::Tiny;

my $data_path;

extract_script_params(
    'data-file=s' => \$data_path,
);

$log->out('START');
$log->die('No data-file param provided!') unless $data_path;
$log->die('Data file does not exist!') unless -f $data_path;

my @lines = path($data_path)->lines_utf8();
my @to_insert;
for my $line (@lines) {
    next unless $line;
    chomp $line;
    my @values = split /\t/, $line;
    push @values, '2020-07-22 00:00:00'; # подходит любое время после включения импорта данных по интапи
    push @to_insert, \@values;
}
$log->out('Will try to add ' . scalar(@to_insert) . ' records');
my $cnt = do_mass_insert_sql(PPCDICT,  "INSERT IGNORE INTO promocode_domains (promocode, domain, ClientID, import_time) VALUES %s", \@to_insert);
$log->out("Added $cnt records"); # нормально, что часть промокодов уже приехала по интапи

$log->out('FINISH');
