#!/usr/bin/perl

=head1 NAME

    DIRECT-124534: Миграция для удаления побитых изображений

=head1 DESCRIPTION

    Удаляем (устанавливаем statusShow=No) картинкам в banner_images,
    хеши которых были удалены из banner_images_formats

    О полученим баннеров для удаления картинок в тикете:
    https://st.yandex-team.ru/DIRECT-124534

    Пераментры:
    --data - файл с bid баннеров, по одному числу в строке
    --dry-run - не удалять картинки, лишь написать в лог какие картинки будут удалены


=head1 DEPLOY

# .migr
{
  approved_by => 'gerdler',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "30 секунд для всех шардов dev7, 40 секунд для всех шардов devtest; не больше нескольких секунд на шард",
      comment => "Перед запуском сделать
        scp ppcdev3:/home/darkkeks/20200728_delete_broken_banner_images.data /tmp/
        Запускать так:
        ./deploy/20200728_delete_broken_banner_images.pl --data /tmp/20200728_delete_broken_banner_images.data
        Можно останавливать или перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use Path::Tiny;

use Yandex::DBShards qw/sharded_chunks/;
use Yandex::Retry qw/relaxed_guard/;

$log->out('START');

my $SLEEP_COEF = 1;

extract_script_params(
    'data=s', \my $data_file,
    'dry-run', \my $dry_run,
);

die "Data path has to be specified (--data=...)" unless defined $data_file;

my @bids = path($data_file)->lines({ chomp => 1}) or $log->die("Could not read bids file $data_file: $@");
$log->out("Got ".scalar(@bids)." banner images to delete");

for my $chunk (sharded_chunks bid => \@bids, chunk_size => 1_000) {
    my $shard = $chunk->{shard};
    my $bids_chunk = $chunk->{bid};

    my $relax = relaxed_guard(times => $SLEEP_COEF);

    $log->out("Deleting images chunk with ".scalar(@$bids_chunk)." bids on shard $shard: @$bids_chunk");

    my $deleted_count = 0;
    if (defined $dry_run && $dry_run) {
        $log->out("Not actually deleting (dry-run)");
    } else {
        $deleted_count = do_update_table(PPC(shard => $shard), 'banner_images',
            { 'statusShow' => 'No' },
            where => {
                bid => $bids_chunk,
                statusShow => 'Yes'
            });
    }

    $log->out("Images deleted for $deleted_count/".scalar(@$bids_chunk)." bids for chunk @$bids_chunk");
}

$log->out('FINISH');
