#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'zhur',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "10 минут на шард",
      comment => "можно перезапускать"
    }
  ]
}

=cut
use my_inc '..';

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::ListUtils qw/chunks/;
use ShardingTools qw/ppc_shards/;

use ScriptHelper;
use Settings;

my $CHUNK_SIZE = 1000;


$log->out('START');


foreach_shard(shard => [ppc_shards()], sub {
    my ($shard) = @_;
    $log->msg_prefix("[shard:$shard]");

    my $bids = get_one_column_sql(PPC(shard => $shard), ['select bid from banners where statusSitelinksModerate="No" and sitelinks_set_id is null']);

    for my $bids_chunk (chunks $bids, $CHUNK_SIZE) {
        $log->out("updating bids " . join(",", @$bids_chunk));
        do_update_table(PPC(shard => $shard), 'banners', { statusSitelinksModerate => 'New', LastChange__dont_quote => 'LastChange' }, where => {bid => $bids_chunk, sitelinks_set_id__is_null => 1});
    }
});

$log->out('FINISH');
