#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gukserg',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1s",
      comment => "можно перезапускать. Работает только на проде"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use JSON qw/from_json/;

$log->out('START');

# потому что sql-миграции нельзя больше 1700 символов, да и копировать неудобно
# список разбит s/([\d\,]{160,174},)/'$1' .\n/g
do_sql(PPC(shard => 8), q!UPDATE `bids_performance` SET `condition_json` = '{"available":"true","categoryId ==":[! .
'1179344,1179345,1179346,1179347,1198554,1198555,1198556,1198557,1198558,64167,1201251,1005686,1206899,45727,1206900,1209728,1209729,1209730,1206901,1321127,1209731,1321135,' .
'1005687,1047867,1206903,64173,1067791,1206904,1206905,1217739,1217740,1230072,1230073,1230074,1230075,1230076,38313,1230077,64179,1283441,1283442,1283443,1283444,1283445,' .
'1288349,1288351,1288352,1288353,1323001,1018461,55483,1047868,1288354,64185,1316840,69012,1288355,1288356,1288358,1111692,1288359,1288365,1288368,1288369,1288370,1288371,' .
'1288372,1129118,1288374,1288377,1288379,1288380,1288381,1288382,1288383,1288385,1288528,1105938,1288529,45737,1288530,1288531,1288532,1212406,1288533,1255239,1212407,1212408,' .
'1323004,55621,1013424,1288537,1255884,1275603,1296144,1211904,1047865,1089867,1247230,1089228,1261142,1089868,1268931,1255386,1254135,51777,1049627,1055295,52745,74160,74156,' .
'1296458,1255103,17716,1250777,1257847,108926,1277309,1341112,17549,1074355,1325328,10386,51704,1341086,1303664,1143506,1208109,1208110,10672,1269156,1269194,1182489,51735,' .
'53450,1256488,51742,1274297,70032,56999,1252829,1268970,1322986,1319605,1274666,1296337,62545,1282766,1282794,1282815,58819,51659,51626,38339,51414,43852,1123526,1206152,' .
'53663,40119,40126,53668,1079414,1012071,1079415,1102986,1117594,86529,1294242,44250,1294241,1294245,1294246,1294243,14350,1001242,1294244,49428,96179,1119401,1156683,1244506,' .
'1339074,96331,123570,1117783,1127354,1298255,1153576,1153577,1294247,1064673,1294429,38368,98201,1078085,1294430,1294431,38385,44234,98132,1119400,1290015,1294448,1294432,' .
'14841,59213,98133,1001243,1290019,1294434,41205,1294470,1294464,49424,96180,1295403,49739,38356,38361,38366,1296097,48771,1298717,38383,1117787,1339073,1368969,38396,1369633,' .
'38348,1119402,1383191,1156619,1084019,1093127,1093128,1117780,96176,1238841,51135,45190,45191,45241,45242,51452,51454,16004,51455,16099,69010,1315951,1316841,1315952,69011,' .
'1316636,1316837,1316838,1316839,1013622,1013623,1013624,1013625,1198643,1198644,1198645,1204046,1238845,1238861,1241358,1238857,1318830,1315953,1318831,1315950,1238842,51134,' .
'45150,45151,96175,1063960,1238843,1238852,98136,1238854,1053803,1238856,45246,45247,1239298,1238855,45176,1239287,1238959,1238960,1238851,1044530,1318704,1044533,1044700,' .
'1044705,1044707,1068737,1074341,1210044,1239285,1239408,1240468,1240472,1244390,1318705,1209433,1239324,1244446,1318706,1209432,1209435,1360406,51358,15250,1047862,1080901,' .
'1113837,1210078,1297275,51333,46667,1051227,1051229,1078201,1340473,1340474,1340475,1340476,1340477,1340478,1340479,1340480,1340481,1340482,1340483,1340484,1082997,1084403,' .
'1094827,1094828,1239385,1297278,1241366,1297281,1136062,1136063,51627,46966,38456,1035409,38457,1035411,1035412,1035413,1035417,1048039,1035410,38460,1035414,38465,1035415,' .
'1035416,1048040,1061626,1084371,38469,39383,49999,1035443,39366,39384,50005,110752,119760,1012721,1122182,1245004,1035445,39360,50010,50011,1008785,1035453,1267637,50000,' .
'1035444,39394,50008,50009,50040,1012722,1058200,1327559,1035446,55547,55548,1035390,1061618,1238042,1267636,44979,46075,10691,50088,1047975,1052675,1059206,1063817,1143963,' .
'1224300,1289389,46080,10693,46081,50092,94755,1047976,1052676,1059207,1143966,1224301,1289390,49771,10686,51156,48359,48370,97565,97564,1076695,1096348,1096349,1098748,' .
'1197493,1220983,1290074,49772,62157,97559,97560,1052657,1059205,1063811,1202180,1332458,45028,45029,50074,1209744,45297,49754,1035448,10161,10163,10187,45298,55689,1057059,' .
'1058232,1058934,1061653,1120567,1254683,1259317,1271379,1035451,10241,50022,1008787,1035452,1267643,49755,1035449,10189,10836,16611,45309,49970,55681,1057060,1058211,1119632,' .
'1120568,1254682,1272782,1035450,15755,45294,1035385,1099452,1238041,1267642,1061624,1061625,49756,10190,1001503,1068881,1120816,1253770,1255471,1119382,1119383,1296287,' .
'1296288,45833,51196,1035454,1035455,1035456,1035462,1238043,1035458,1035459,1035460,1035461,1238044,1055269,1055270,1055274,1055271,1055273,1055276,1082374,1061619,1061620,' .
'1061623,1061621,1061622,49760,49991,14884,49992,49996,49761,10243,10263,12490,14555,46422,46447,49998,52326,110751,119758,1035466,1057083,1105964,1120574,1238093,49765,14564,' .
'46427,118363,119752,1035467,1061629,1209726,1238095,49997,49762,10385,14560,46453,49976,52327,1008793,1035388,1260206,1260795,49766,14568,46429,118364,1035468,1058280,1061628,' .
'1126670,1260204,1290100,1290101,1290102,1303415,1291735,1291736,51359,46404,51341,46409,46419,51342,46405,46411,1077719,1077721,1077722,50050,14662,50054,51385,39346,1089330,' .
'1073924,1250783,1260787,1260788,45265,1089139,94727,1089264,1089140,1089167,1089168,1089184,1089185,1089191,1089226,1089141,1089156,1089157,1089192,1089281,1089144,1089178,' .
'1224389,1089194,1089145,1089195,1089267,1092830,1089146,1089186,1089187,1089196,1089148,1047883,1089149,1089232,1089150,1089233,1089151,1089165,1089166,1089179,1089175,' .
'1089199,1089234,1099453,1228054,1094809,1133718,1120569,1120828,1267638,1267639,1267640,46388,1089316,1073923,1077741,1089319,46396,1194205,1194206,1260793,1260794,1290111,' .
'1290112,51411,1129250,1129251,1132883,1132884,61530,1089342,1006956,1089343,61531,1291725,1291728,61538,1089318,1089324,1089366,1077715,1077725,1089369,1089367,1089370,' .
'1089368,61539,1092813,1250730,1250731,46969,40051,53634,53635,53641,53642,53636,53646,53653,53637,53647,53664,53666,18186,1044610,1045196,1073862,1113836,1053478,1053479,' .
'1053480,1053482,1057041,1057042,1057044,1057045,1057046,1061654,1117258,1146777,1068663,1068664,1076639,1076646,1105894,1105896,1105897,1127251,1127260,1129188,1129189,' .
'1120557,1120558,1120559,1120560,1135813,1135814,1133078,1133079,1133080,1258497,1256825,1257839,1258500,1258501,1300324,1300328,1260780,1260782,1260783,1290075,44306,44319,' .
'61616,44307,61617,1035441,1057348,1061709,1063802,1120561,1064527,1064528,1064529,1120205,1223269,1258823,1260796,49741,40029,1090055,1297317,1090056,1053485,1089685,1089686,' .
'1089689,1089691,1089807,1135815,1261605,1090060,1287212,1090061,94735,1090065,40045,1089692,1092755,1254715,1315928,44293,1089698,61634,1089702,1035435,1132886,1090112,' .
'1079002,1079003,1079004,1079005,1090113,44302,1078996,1078998,1228109,53662,1053489,1053783,1135812,1237896,1057051,1253777,1253778,1253779,1258499,1257838,1260779,1269040,' .
'1269041,46970,49705,94154,15255,1102951,1103973,1203160,1235354,95082,48788,99035,99036,1013389,1013391,1022030,1055107,1065415,1074141,1082587,1112470,1133456,1191088,' .
'1231134,96349,1091162,1120545,1055110,1055111,1133214,1195354,1254713,1297318,1319406,1057064,1057065,1123898,1058195,1103053,1181792,1196955,1224524,1242543,1059860,1095534,' .
'1061660,1094920,1092744,1339264,1094811,1244950,1095524,1133069,1201364,1290940,49706,40990,39793,40991,41043,1064059,39777,48639,79766,85193,1201832,1201833,1253262,1256073,' .
'1256074,1294827,1330835,1333436,1133073,41072,48502,1093992,1093994,41101,39787,48439,48444,1059872,1079446,1123005,1257888,1257895,41122,39795,41123,48702,48813,48916,49710,' .
'49715,1072320,1233962,50227,55656,86172,86173,98326,98330,98337,1010524,1093991,1007521,1007522,1007523,1053462,1053463,1053465,1053466,1253767,1058908,1063508,1063509,' .
'1063510,1093997,1094001,1112758,1094003,1094814,1126339,1202188,1135799,1250558,1299326,1299329,1329371,1337597,1337620,1232511,1247494,1257192,1258804,1258812,49707,49708,' .
'13342,41073,48510,48513,49709,1064060,41044,48525,48633,48635,48643,76961,1013598,1013601,1111693,1111694,49716,1257889,49717,48700,94599,94600,98341,98342,1007519,1007520,' .
'1061659,1005805,1135800,1135801,1135802,1135803,1202187,1271380,1299328,1253768,1338643,1323498,1338646,1064056,1009872,15249,1064057,14156,1071500,1064079,1010520,1257891,' .
'1257893,46971,39715,51558,1283349,1045391,1247215,49734,50107,46482,1238086,53744,96295,99685,99688,1043679,1043680,1210436,1085568,1112806,1236335,1157462,1236336,1255198,' .
'1343326,49735,1238075,109206,1197500,1238077,85842,46976,45680,50114,50129,40033,45681,45693,55603,55604,1035463,1035464,1035465,1057353,1058236,1075961,1120214,1123019,' .
'1284884,1289459,1289460,1289465,51355,1084115,1084116,1253015,1123020,125706,94121,45700,45701,1289469,46655,1068803,1068804,1075653,10504,46656,68331,1115823,1126874,1126875,' .
'1126876,1265232,1271949,46901,103865,46902,63300,103866,103867,103868,46906,49769,55617,94775,96268,55620,1061678,1120186,1289454,1289455,49770,55618,96278,1008010,1008011,' .
'1255370,46922,48725,1074153,1077700,1001502,1298915,1055300,51155,46030,1088648,1061668,1061669,46994,1088645,55631,1088646,1088647,39230,55629,46031,94776,94783,1120188,' .
'1120189,1336216,1336217,51413,1075657,47972,98183,1088658,98184,1088660,1300438,1088659,98186,1088661,1120821,1120822,1080141,1121061,1081162,51527,1001501,1123534,1240673,' .
'1240674,46977,39799,1121194,1115305,1168525,1115306,1053490,1089788,1115307,1077729,1115308,1058224,1120845,1115310,98142,1061687,1328668,1115311,1089783,1115316,1047967,' .
'1115318,1084393,1115319,1061706,1095268,1115320,1252975,1115321,1061705,1113839,1207714,1224384,1267635,1115323,39802,1092767,1115327,1089755,1115692,15970,1089763,1092781,' .
'1092793,1247607,1262094,1115693,1094807,1168529,1168530,1168637,1218642,1328672,39951,38478,39952,45726,45730,45734,94450,104486,1058237,1058940,1073011,49752,44359,1153573,' .
'1153583,44367,44350,51382,1008800,51383,44351,1057349,1129399,1214456,1214459,1164457,1164458,1214451,38560,1256291,1256292,1122216,51375,1035217,1058212,1253059,1260815,' .
'51377,15071,56160,119765,1035153,1260810,51378,10130,41298,44368,44377,48827,1009852,1058210,1061708,1258880,44380,1122211,51371,39736,39739,44387,1009850,1076682,1119529,' .
'1120840,1136129,51372,44363,1053472,51373,15052,119763,1122217,1061692,1061693,1122218,1058921,1122219,1008798,1122220,1008796,1122221,15068,1053476,1122222,1008799,1058919,' .
'1122212,1122226,1122227,1129401,94798,44390,94806,15781,1053471,1057351,1061691,1064775,1228052,1122438,1047960,1053470,1059882,1064160,1120843,1263194,94803,94807,94804,' .
'1057350,1122486,1228051,1245795,1122437,1057465,1064177,1111301,1131560,1203574,1112106,1093531,1093533,1120846,1115703,1115704,1115707,1094806,1115708,1117220,1115709,' .
'1089743,1115710,14534,1089750,1092776,1120841,1115705,1115711,1057749,1062919,1092777,1258462,1115712,1115734,1120209,1187859,1204449,1231516,1258175,1328766,1262251,46987,' .
'39469,39470,95820,39961,95563,1058942,1052655,1111614,1069998,1111616,1111629,1111633,1111635,1113671,1115167,38112,1082356,1084522,1174977,1203612,1222081,1254718,1256043,' .
'1094818,1260475,1283566,1007650,1368695,38452,1118692,44091,1118693,1118697,1118694,1119109,1256040,1119110,1256041,1256042,1322783,1261350,1322787,1163239,1057035,1322838,' .
'39999,40000,40420,38565,61541,51401,40431,40475,51402,38107,40438,40449,40457,97985,99583,95808,40484,97995,39695,1105212,1105213,41307,41308,41390,1092740,1007530,95373,' .
'95391,95422,1007531,1113027,1052649,1052650,1052653,1326983,1111597,1111598,1111600,1111601,1210026,1115605,1118681,95380,1115606,1116938,1124343,41391,1254717,1292968,' .
'1222080,1292969,1293806,1198986,1293814,1293816,1293819,1293820,1293825,1293828,1111659,1069625,1007643,45742,95752,45750,95753,45743,95755,45763,45778,95778,45783,50128,' .
'10260,46085,39601,95595,46097,95600,46086,46343,15243,97672,1153363,97674,46344,1153318,1153319,1153320,95864,1153324,1153322,1048036,1222079,1111654,97650,1111655,1111656,' .
'1153362,1090216,1259364,38566,1259348,1259363,1261342,1300330,95564,1089985,51405,15247,39568,1319748,72185,1089986,1089991,1315371,1089987,72189,1089994,72192,72193,1047906,' .
'1007644,1052654,1113669,1261346,1326982,46988,40495,40496,85768,1073700,1026363,1076874,46265,1217349,46273,46289,49746,46274,1224289,1083427,1201846,49744,46171,1136781,' .
'1136783,46181,46186,1013446,46198,50124,10118,10156,123558,1038006,1038007,1053461,1117788,1203610,1203611,1203778,1203779,1247125,1337537,1135781,1342382,1337627,1342383,' .
'50213,1088557,1088566,1088567,1088570,1088584,1088585,1088576,1088578,1088579,1088590,1088591,1088592,1233961,1088594,1092875,1092877,1092878,1088607,1088608,39546,1088610,' .
'1088611,1116436,1088613,1088614,1088615,1088616,1191124,1088617,1130778,1130779,1088618,16145,38444,51272,14551,96144,1008471,1126422,1047939,1088619,1088620,1088621,1088623,' .
'14881,1088627,1121055,1088629,39556,1088630,1088631,1088632,1053459,1053460,1088633,1088634,1099107,1125403,1088636,1088637,1088638,1112148,1088588,1088589,1144145,1144146,' .
'1217365,1217366,1243504,1243505,1260777,1273864,1287966,49750,46245,46250,46256,1060282,1060283,46261,55786,46262,48832,50109,48833,49077,1286843,55784,49712,50112,51132,' .
'47317,50651,10694,48896,71919,93876,98392,71792,14204,1263197,98393,98394,98398,98399,98405,98406,1058946,1058947,108611,1112146,1053439,1253772,1053453,1253775,1253773,' .
'1253771,1111732,1111733,1135796,1263560,1316583,1218643,1218644,1234452,1234453,1234456,1234457,1316966,1316967,1316970,55782,1047137,1010621,1010622,1010623,1010624,1010625,' .
'1010626,1062405,1062406,1053440,1053443,1053445,1076276,1075973,1075974,1076878,1105932,1105936,1112140,1112141,1120217,1120215,1218750,1218752,1234458,1234459,1270781,' .
'1270782,1270784,1271285,46989,44062,44063,44075,44080,48523,1076138,50051,14475,50057,1210839,1257817,51148,51616,1089449,1089450,1153580,51617,1089658,46788,94945,95336,' .
'1089667,1089665,1089668,1111843,1112075,1089661,17459,1089672,17451,1235348,1092881,1261129,1105300,1105301,1105302,1112218,1112219,1112220,1294368,1294369,1337447,1337448,' .
'1120466,1077737,1201266,38436,1064313,51152,38298,60966,94138,94139,94142,1055298,1073874,1105970,1111833,60971,1111835,38433,38434,45034,58768,1111838,1111839,1111841,17450,' .
'58772,58773,93558,1112186,1007997,1007998,1150070,1207093,1257982,1285628,1301228,1058680,53155,1096310,1111840,1118874,1150069,1177417,1287402,1061715,1094835,1150068,' .
'1153575,1061721,46782,1061723,1105305,1120536,1245793,1247171,1250301,1337440,1112074,1134831,1134832,1116443,1116448,1089675,1116449,51628,46963,41145,109441,97580,109442,' .
'1065457,1065469,1125395,1126380,1079419,1081159,1057079,1094861,1111772,1111869,1168639,1189391,1189392,1253343,1271284,109443,70483,70484,78295,1077712,1127348,1127351,' .
'1127369,107099,51228,14496,14499,14504,14510,15864,94678,107179,1058230,51229,14446,1246326,107399,94670,1064546,1065465,1065466,1065468,107401,107415,107422,107428,1081949,' .
'1081950,1081951,1081952,1081953,1116451,1116452,1116453,1126375,1126377,1116455,1102987,1116456,1126385,1126386,1126387,1079421,96264,1111774,1112150,1112172,1258813,1271381,' .
'1338509,1323483,1338510,1338511,1338513,1338517,1338519,1338555,1240614,1240615,51231,41203,1116454,1116457,1116458,1116459,41405,41418,1084365,1057054,45341,51220,94971,' .
'45350,94973,94975,1210027,1079442,1079443,1079444,1247134,51745,18924,45342,1057018,1058930,1074136,1129408,1129745,1129746,1145331,1183027,1060254,1095277,1055294,1113039,' .
'1247167,1253336,1258881,1264612,1264610,45383,1078086,1094885,1120206,1290950,1290951,1290955,46148,94615,94616,94617,1008194,110009,1180165,1180166,1180167,1104666,1111468,' .
'1111474,1112475,1112476,1201831,1126868,1068714,1203550,1255125,1286285,1290372,1018431,1290371,1324736,1329374,51138,51317,1088402,1058203,1088403,1201246,1201247,1089927,' .
'1089932,1089928,1055074,1055076,1112157,1112160,51396,1089837,1089849,39235,1089890,1093538,1245084,1089838,1089904,1089840,1089889,1112267,1201861,1089841,1089873,39455,' .
'1092714,1092928,1092929,1089842,16205,39306,95073,95079,1084416,1089854,39233,1058199,1089855,1089856,1117765,1117770,1117771,1117772,1117773,1089896,1095511,1089845,1059863,' .
'1089895,1089846,1057022,1057023,1089860,1094870,1092640,1092641,1094923,1094924,1094925,1094926,1112077,1112078,1265577,1105217,1105218,1113029,1113030,1113031,1113034,' .
'1113037,1315942,1134473,1134474,1203547,1207087,1153584,1153587,1253347,1253348,1253356,1253360,1253362,1253364,1267955,1267970,51398,94990,94151,1253781,1298647,51399,' .
'1089914,118598,1125397,1134129,1089915,1061609,1089916,1089923,1089918,46140,1191078,1287971,1287973,1089919,72154,94623,94614,94628,1006093,1060868,94650,1303660,1071739,' .
'1206410,1303662,1303663,1303665,1303666,1089920,1073870,1103747,1089921,1073584,1076398,1089922,1037209,1112477,1112478,1112489,1121600,1121601,1131077,1131082,1129043,' .
'1129044,1255248,1255249,51400,1089913,41456,95075,1089937,1047887,1047974,1092936,1089939,108924,1092961,1095515,1095516,1115815,1115816,1115821,1115822,1117576,1247152,' .
'1247153,1117582,1247143,1247144,1247145,1247156,1094871,1094873,1116179,1332398,1094928,1094929,1105239,1112173,1112174,1112175,1112176,1112584,1141953,1125386,1253368,' .
'1253369,1255225,1271387,1271388,1288363,1084229,58971,38286,58963,58976,58986,1075962,1075970,1098524,1098526,1098528,1235690,1235691,1235693,1247150,1163232,39458,1163235,' .
'1302277,1223567,1089899,1090180,1245094,1247133,1245844,1117427,1117431,1117432,1117524,1125394,1240664,1246299,1246300,1246301,1247140,1111845,1247141,1247151,1247154,' .
'1298253,51139,38318,10010,17816,1073871,1075872,1241322,1321374,1336174,39342,5981,1064530,41458,1025655,1221005,1221000,1234434,94644,94647,1242573,1242570,1057036,107068,' .
'107076,1079440,1079441,1081948,1057037,1074150,1113038,1197310,1201385,1077539,1271383,1316579,1084223,38257,38258,51551,16620,38269,1075964,1236273,58917,37920,38262,1080909,' .
'1095445,1095278,1095279,1095280,1095446,1121936,1201433,1309907,1309908,46980,45091,45092,45094,45697,46682,12517,46683,1019930,1058283,1072323,1120810,1260499,1298375,46725,' .
'46726,48858,1001499,1019935,1058235,1072324,1120528,1120811,1260404,1298374,46770,1063813,1063814,1118671,46983,44920,44923,1048024,1067300,1346890,44930,48472,50588,10684,' .
'1003592,1003594,1024160,1256913,109100,1048003,1064697,1174981,1209743,94923,1079448,1137758,46758,46759,119767,1001498,1019939,1058285,1120812,1298371,48865,1078094,1078370,' .
'1093529,1120809,51406,49818,1089795,1078095,1120813,1120823,1260210,1260211,51150,1089809,1089831,1012752,1089814,1246932,1089816,110451,123656,1067296,1094831,1116700,' .
'1112164,1112165,1112168,1112169,1112171,1193385,1193388,1247540,1094833,51151,1089800,1076038,1261567,1204450,1120825,1230590,1047963,1069591,51630,46958,37939,49724,37981,' .
'37985,51360,38008,38012,38016,51362,37988,49663,51363,37952,37955,1300071,51364,37992,51368,37964,40133,51563,40164,51564,18000,40150,40158,49053,1297366,51565,40156,51566,' .
'40134,51567,40172,51569,49055,51572,49057,53633,18007,119723,119724,48729,51669,17443,17444,17474,17477,17550,17693,51678,17710,17712,1161028,1161027,17688,1201242,51670,' .
'51675,17485,51671,17546,17548,51672,17449,17732,69608,17611,17631,69613,17445,17511,69614,17551,69615,18105,69616,17448,1094907,51673,51680,17898,51683,18155,69619,17832,' .
'69620,17838,1112762,1241663,69622,17941,69624,17907,95313,1204849,1204850,96111,96112,96120,1058711,96122,96123,96131,96132,96133,96135,1052664,96136,96137,96138,1052666,' .
'96208,96209,96213,96226,96227,1052663,1045385,1045386,1098953,1098954,1098955,1099381,1099383,1103057,1203783,1163176,1200923,1200924,1200925,1200927,1200928,1200929,1200932,' .
'1200933,1200934,1200930,1200931,1200936,1200937,1200949,1200950,1200953,1201387,1201390,1201391,1201393,1201394,1201395,1292340,1201396,1201397,1201399,1201400,1201389,' .
'1201441,1201442,1201443,1201445,1201447,1201448,1201449,1201450,1201451,1201453,1201454,1201455,1201456,1201458,1201459,1201467,1201468,1201469,1366103,1201457,1244333,' .
'1244334,1244335,1244343,1244346,1244353,1244364,1244365,1244369,1244370,1269050,1287277,99741,99742,99743,99745,99750,99751,1007245,1007246,1008428,52010,38091,17957,38295,' .
'49723,37966,38000,38002,38004,51314,5983,108649,1052671,1092948,1120834,1261038,46477,1058282,1060373,1099354,1129032,1261039,51370,38095,1105569,38100,1103337,1261037,' .
'1315954,51445,1119524,15924,1119525,69618,51686,1089952,18016,69625,1089949,1237065,1089950,1089951,98414,1112585,1112586,1120836,1120847,1299881,1299882,40183,1200935,' .
'1201398,1201446,1204842,1244351,1269051,1299915,16926,37948,1200939,1201452,1299916,1331430,1299917,16818,17488,1299918,1299919,1299920,1299921,1299924,1299925,1299929,16820,' .
'17505,1299933,1299935,1299937,1300080,1333789,1299930,37972,1073445,1244359,1299932,1299934,1299936,1300077,1333788,1359017,1359018,51365,37940,51570,40139,69611,18045,96217,' .
'1201460,1201461,1201462,1201464,1201466,1359019,17657,1201463,1359020,1201465,51631,46984,39925,61555,1044517,41403,46169,1090096,1090100,1111860,1090101,1090030,1090031,' .
'1090033,1090103,39931,1090104,39933,1090035,1093432,1093522,1090108,1090038,1090109,1090040,1090110,1076148,61556,1090111,14575,1008763,1063761,44083,1093443,44951,1007006,' .
'115029,1007007,1007008,1007009,1328034,1111847,1111848,1111849,1111850,45420,55568,55569,55570,1053491,1161097,51154,46166,1084906,1084915,1084916,1084917,1093422,1093424,' .
'1099355,51687,48719,95303,95304,1122971,39499,85870,1244500,1244501,1397915,16269,1247786,1247824,1380834,61794,61795,1380835,61784,61785,1380836,46964,99505,1290109,1093428,' .
'1093429,1082624,1082627,1340234,51633,46972,49727,1325915,1325916,1013634,1013635,1013636,1013637,1325884,1325885,1325886,1325887,1325889,1325890,1325893,1325894,1325895,' .
'1325896,1325897,1325898,1325899,1325900,1325901,1325902,1325903,1325904,1325905,1325906,1325907,1325908,1325909,1325910,1325911,1325912,51478,55591,96158,45007,1074169,' .
'1078400,1298396,96159,96160,96165,1078396,1112069,1315683,1061636,1262086,1319846,1319847,1078087,45001,1078089,1078090,1153514,1082548,55593,45017,96153,1078091,1121026,' .
'1153513,51636,1163210,1163211,1163213,1329610,1267737,1267738,1267739,1267740,1267741,51634,46986,38120,51189,1008472,1126608,1174473,14180,14887,38162,51195,51924,38134,' .
'1174498,14267,21405,1073541,51920,51934,1076192,51925,51926,38182,1174480,14181,1126594,61513,14797,1008519,1133471,51921,14285,38127,51922,38131,51923,38177,1034967,1034968,' .
'54640,54653,1174499,54668,54671,60999,60738,1199125,60739,1284827,60776,60778,1053727,1168655,1168652,60925,99199,99210,99213,99200,99335,99336,1127411,1230253,1174518,99314,' .
'99320,99374,99375,1093402,1126593,38185,1243650,1284826,1191128,1243569,1191129,1243579,1243623,1243580,1243585,1243662,1243581,1243634,1243591,1243598,1243635,1243638,' .
'1243639,1243882,1243908,1244407,1244403,1243582,1243583,1243584,1243618,1243622,1243894,1243896,1243897,1243588,1243589,1243665,1243592,1243586,1243587,1243601,1243593,' .
'1243595,1243645,1243646,1243674,1269911,1269912,1269913,1269915,1269921,1269928,1303098,1289714,1289716,1289916,1289723,1289724,48071,1126244,1126252,52989,53157,1093016,' .
'1093019,1093020,1093022,1093023,1093024,1093025,53203,1093002,1099023,1093003,1093004,1093005,1093006,53212,1093008,1093009,1093010,1093011,1093013,1093046,1093047,53222,' .
'1092991,53223,1092992,1092993,1133557,53532,1093102,53533,1093103,1343202,1005830,1092964,1092965,1092966,1092967,1092969,1092970,1056106,1084975,1084993,1085005,1085019,' .
'1092971,1092972,1093043,55258,52445,52478,52504,52520,1019761,1064669,1183526,1040285,1067770,1067781,1067771,1098695,1067775,1067776,1098696,1067777,1067778,1098697,1067779,' .
'1067780,1098698,1067784,1067785,1098699,1067787,1067788,1098700,1073518,1098701,1067786,1116182,1116183,1116184,1116185,1093054,1093055,1126262,1126433,1126434,1126550,' .
'1126553,1126554,1126557,1126560,1126671,1185542,1203931,1220905,1245601,1345454,1345455,1345457,1345562,1345564,1244394,1244395,1244398,1245810,1245811,1267186,1267194,' .
'1271278,1342771,1342772,1126265,49924,52984,1093027,49921,1093097,52985,1093032,49922,52986,1093034,40272,52987,1093033,49923,53540,1093035,53541,1093095,1343203,52444,52464,' .
'52511,52529,93940,1063885,1063887,1098530,1098531,1139853,1246666,1319582,1337916,1337918,1337919,104467,118968,1085984,1085998,1085999,1086000,1086002,1040287,1048046,' .
'1067772,1098663,1067773,1098664,1067790,1098666,1095318,1098667,1095319,1095320,1093082,1093086,1093089,1126551,1071766,1126552,1126558,1185543,1220904,1220908,1220911,' .
'1220913,1245345,1245594,1245596,1245599,1262128,1262129,1345453,1345563,1244392,1244393,1244399,1244402,1271279,1346132,1346361,1346369,1126293,52990,52544,52545,52546,52547,' .
'52548,93951,93960,1067789,1113777,1113778,1113779,1113781,1126294,52596,53062,1098709,52994,1126435,1226080,1226081,1126559,1126246,1126267,1126268,1085987,1126271,1098665,' .
'1095317,1126323,1346365,1126278,1126292,118980,1126247,1126251,1129054,1346366,1126266,1040288,1093090,1244435,1244400,1346364,1126299,1163703,1231106,1231107,1126248,1126261,' .
'1224193,1126249,1126269,1093101,1126270,1085977,1346370,1126250,1126255,1008266,1008267,1224194,1258970,1125537,1246188,1271376,1126272,1129058,1129059,1245808,1245809,' .
'1246667,51479,43963,43940,43949,43959,43964,48724,69364,43978,43979,48113,49790,49791,1037674,1064534,1105975,1253153,1255120,1255130,49792,49793,49794,49795,1116912,51410,' .
'39985,39989,1201244,46109,46110,49809,49810,49811,49813,49814,1063027,1163275,1163276,52648,43984,1086715,1086686,61813,1209955,1086717,43985,1058899,1095321,1102162,1095323,' .
'1102164,1095325,1095348,1102166,1095326,1095354,1102167,1095327,1102170,1095330,1102172,1095332,1095370,1102173,1095333,1125042,1125043,1125535,1125044,1125045,1125068,' .
'1125069,1125533,1197059,1197061,1197062,1197064,1197067,1197068,1246174,1246182,1246189,1246183,1246184,1246192,1287335,1287336,1262132,1262133,1262134,1262135,1262138,' .
'1262141,1345052,1345053,1085736,1085737,1085767,1185538,1261843,1261844,1085827,1085843,1085881,1085907,1085908,1271283,1086688,1095380,1102147,1095390,1102148,1095382,' .
'1095393,1125047,1125046,1125541,1125049,1125050,1246186,1246187,1271282,1345019,1345049,1345050,1247135,1253162,1253163,1253164,76343,70600,70601,1270695,1296133,1259378,' .
'1294333,1296368,1296444,1296445,1325323,1325330,1272168,1272171,1292047,1056184,1056186,1087431,1087432,1087449,1087450,1087461,1087473,1087478,1087479,1091186,1105940,' .
'1156605,1209721,1209722,1233556,1233557,1255474,1255475,1123958,1124979,1168654,1243886,1243888,1353912,1068509,1168658,1008521,1073939,1353913,1244391,1359024,46959,38609,' .
'1053467,1053468,1053469,1074708,1074713,1275885,1275887,1094942,1134575,1202184,38703,94659,1089960,38721,1058209,1089965,1079707,1089801,1077739,1291742,38719,48828,49780,' .
'110760,12513,110763,110771,1099277,1250174,1267646,110761,43858,110762,110770,1061853,1267649,49781,110757,12514,110765,110773,1094940,1250175,1267644,110758,10056,110764,' .
'110772,1267645,49782,110766,10058,110768,110767,12515,1262140,48829,51442,15775,43866,48830,1284965,1284967,1284970,1284971,1284974,1284966,1284968,1284969,49786,49639,49787,' .
'1123772,1123773,1123774,1228077,1284982,1123775,1123776,46960,38498,1035422,15022,38510,49595,55498,55507,1035419,1035424,1284931,1035426,48399,1035429,1035421,1275587,' .
'1079714,15026,38499,38502,38512,38517,1035420,1135805,1135806,1135807,1135808,1250178,1250179,1250180,1290061,1267653,1290062,1290063,38532,55794,38533,49608,1135809,55795,' .
'55514,38543,1035434,1079716,38544,38550,1079717,38547,1079718,49603,49605,55504,55511,1079719,1058857,1267652,49742,1089953,1042333,1089954,1025090,1089955,1094932,1089956,' .
'1089958,63343,1284932,1095529,1099353,1123948,1092896,1267654,1267655,49743,49613,46961,44971,44976,49826,46461,87191,40043,46470,49733,94440,1058278,87196,46474,49950,' .
'1238096,51407,39728,1089996,1090001,1089998,1090007,51408,1089687,1089688,1089803,98181,108717,1291411,108724,1061603,1291762,1268341,1291764,1291765,51540,1061598,123528,' .
'123529,123530,123531,1061597,1291402,1061599,1061601,1239381,1090005,1239382,108716,1090006,1090009,1239383,1239399,1359016,108722,1239384,46962,38728,38729,38736,123547,' .
'1092897,1094824,1094825,1094826,1121598,1258164,1256922,1334112,1334113,1334114,46979,49816,44439,18639,44440,1076899,1076900,1204654,1059888,1204649,1204655,44444,44447,' .
'1204653,1337632,49817,1001248,1092963,44456,44463,51395,1058927,1058928,1058929,50596,52298,46697,49509,52300,1092738,46700,52301,1047882,1047955,1094918,1111705,1201856,' .
'1205727,52299,98272,1204641,52302,52303,52304,52305,67504,1153519,1206155,1206156,1291770,64913,18743,41292,64914,95294,96257,1113844,96346,96347,1001505,1001249,1119630,' .
'1206933,1209937,1224315,1322810,1204635,1204636,1254723,1239672,1239673,1260764,1260797,95283,55544,55583,55577,55578,55579,94654,94655,1204786,43656,1035442,1057352,1082385,' .
'1099451,1204639,1209936,1253765,85868,1049889,1049890,1120572,1064146,86419,1127750,1151966,1263731,1263569,15944,1263570,1263571,1263573,1263574,1263576,1263577,1263578,' .
'1263579,1263580,1263581,1263582,1263583,1263584,1359609,46957,51639,89043,1079919,1103990,1153515,51640,1134128,51644,50711,1070563,1074452,1313505,1313506,1313507,48925,' .
'108755,108756,108757,108758,108759,108760,108761,108762,1320518,1320519,1320520,1320521,1320522,1320523,1320524,1320525,1320526,1320527,1320528,1320529,1320530,1320531,' .
'1320532,1320533,1320534,1320535,1320536,1320537,1320538,1186709,1186710,1186712,1186713,1186715,1186716,1186717,1186718,1186719,1186721,1186722,1258177,1258178,1258182,' .
'1186711,1186723,1186724,1186725,1186726,1186727,1186728,1186729,1186731,1258176,1258179,1258183,1258185,1258186,1211320,1211321,1211322,1211323,1211324,1211325,1211326,' .
'1272439,1272441,1272442,1272443,1272445,1276210,1267712,1267713,1267716,1267717,1267720,1267721,1267724,1267725,1267728,1267729,1267714,1267715,1267718,1267719,1267722,' .
'1267723,1267726,1267727,1267730,1238844,1252178,1252181,1161013,1252822,1120260,93681,94111,94187,94191,94227,1327272,1269155,1131247,108938,1328431,97046,97060,67680,1068733,' .
'49797,1095502,1293154,1134130,1283654,1284238,1190956,1270287,44790,1191454,51721,1284241,1131152,1126940,1330355,1095342,1095351,1095377,1125542,1199314,96984,1284709,' .
'1293147,1011419,1272175,1055301,1282764,1045061,46013,1282767,1282795,67770,49677,1049779,1120532,1256547,1292971,1064274,58806,62547,1094934,1275594,1156377,1250171,1143507,' .
'1199315,1099345,1099346,97796,1269193,1277503,1274685,1274710,1301341,46492,1301959,39918,45873,1136377,51765,1261733,1339156,97376,1301933,1119518,1301400,108950,1133505,' .
'1204059,1294433,1244448,67672,1061648,1055116,1264568,1286300,1286301,1316952,67689,51731,45421,58823,1300428,1133217,51849,94221,1251359,1186532,58800,1261871,1045400,54797,' .
'1133568,1261409,1131251,1269197,1186548,1131244,1131245,1283548,1186267,1162860,1131243,1131249,1131242,1058272,16017,16090,1343349,1161036,1064231,1327663,94050,94102,' .
'1229707,94106,94116,1229708,94108,94117,1229709,17868,1327661,1123706,1123716,1123707,1123717,94109,94119,94195,94199,1282768,1282810,1282769,1287967,58816,44856,68419,' .
'1274356,1275328,1343311,1287995,1329951,1261137,1300262,1330376,1274358,1318785,1274359,1261155,1053444,1282734,1094927,1095495,1267958,1301221,59114,88642,1218545,1090836,' .
'51728,1320007,1268964,1268939,1268937,1268938,1060869,1274308,1239336,1327668,1327672,1095339,1095357,1095361,1095364,1095374,1095378,1095396,1095400,1095406,1125531,1288178,' .
'51799,1090068,1094838,1255385,1330354,1064233,1255597,1261735,1288175,1094605,1301222,1143508,1327669,123574,1176604,1079726,1094946,1237893,1117155,94219,1327674,1274727,' .
'1274678,1325325,1325324,1217747,1252063,1201470,1283440,1288535,1206447,1067311,39842,69623,96218,1223249,108679,108661,108710,108668,1250762,1250772,1088654,1270639,1008479,' .
'1255116,1112637,1236479,1257822,1174474,51753,1274668,74155,1105144,1316953,1270092,1270093,1111883,1318491,1111489,1270087,1270088,1270089,1270090,1270086,94913,1301342,' .
'1274712,1301345,1319208,1301960,1174479,1297164,67683,1211842,51791,1088409,1219115,1275573,1162928,1131143,1035135,1162871,1328031,1176058,1268069,1268059,1268098,1276667,' .
'1136351,1283897,1283904,1269191,1068491,1252807,1272183,1090842,1064352,1296142,1276149,67658,95561,19256,1251350,1275324,1256918,1090843,1090813,1128250,1095490,1175000,' .
'1094945,1102073,1162631,94105,1207381,1089169,1090715,46377,1261741,1300228,1275582,1343321,1269190,1261737,1343322,1162644,1048975,51859,1329839,1274305,74498,1296139,' .
'1269189,1131150,108962,95332,39851,1271937,1045750,1288212,1320937,1070338,1049619,1245866,10391,14628,1090814,1067312,1136344,1274692,1275596,1294463,1092959,1322817,62549,' .
'1268055,1122183,1064082,1181786,1301156,1274669,1258180,1258181,1112980,108974,1235559,1293167,98459,1044531,1090451,1090759,1090837,1293148,1276211,1276212,1282773,1282813,' .
'54736,1075875,1270720,43879,40421,10040,1064872,1117178,1277509,51632,61679,1335607,1131246,1026349,1112938,1318836,67525,1283437,1090844,67729,1277636,1331442,1105598,' .
'1111837,1186958,1267975,1120837,74472,1255382,1092647,1102061,1251356,1256400,97022,52768,1163178,49825,1320006,1335654,44134,1343336,1293155,1206446,1323450,1088602,67688,' .
'69235,1131125,93508,1115028,51695,37968,50233,51403,1274313,1274311,1263244,1293140,1274293,1319221,1149385,1129429,1317233,97473,1288361,1094830,1007671,1136547,1275551,' .
'1275572,1284239,1284240,1162929,1139898,1186272,1335711,1149406,1253014,1252805,1120827,1106011,1301981,1179320,1053657,1274369,51915,1261148,1261744,44785,1300226,1051178,' .
'1269188,1260952,1295432,1274307,1193886,51784,64098,1341105,1327662,1327666,21328,67731,1182485,1124317,39991,1117209,1163174,1275568,39721,1297279,94226,1051214,1065873,' .
'1238958,1245864,1245870,1318707,1186536,19754,1088580,19363,1342932,51758,1137183,1251351,1275283,1088599,1283949,67998,58803,1044703,1051128,1200952,1133431,1105282,1084755,' .
'1284200,1239203,1270288,1261424,1261752,1261425,1261753,1261756,1115029,1261423,1131147,10392,94230,1296372,1296437,1296439,1296442,1296443,1296452,1296455,1329144,1296459,' .
'1296369,40951,1269187,1058274,1006496,1275583,1044543,40128,62740,1277510,1090767,1330365,58809,1088622,1112801,1119628,97137,1301375,1088410,1090896,94107,94118,94228,14187,' .
'1284614,1310498,1049630,1070565,1120250,1105937,1267995,1283785,1089125,1275325,1251829,1092127,1095352,1102176,108986,108998,1143509,1136364,1059905,51929,1005685,1269186,' .
'1238957,1051213,86338,1217762,1217763,1283438,1286864,1020218,111541,1131415,1115812,69595,1201249,1073443,1319597,1277630,1111830,17830,1261069,1255244,1332456,1089373,44852,' .
'1261158,1044745,1245863,1243868,1082388,1090062,44974,1058275,1055075,1095322,1095324,1095328,1095329,1095334,70244,18971,1090095,44822,51825,51824,1256486,1094941,69326,' .
'40506,51776,51692,51918,51734,74171,67799,1242519,1095381,1095383,1095384,1095385,1095386,1288214,1274306,1084736,1080890,1143510,1018655,1111462,70243,1293135,1190947,' .
'1131136,1340784,1069619,1274716,44825,1269185,1269183,1282782,1269184,1092876,1292970,1300219,1089471,51691,1092937,1051215,1207379,1241451,1257240,1290414,1294416,1257896,' .
'1309737,1122916,1064311,74147,51802,1301408,1143990,1252803,99568,46710,1328432,1049622,1137514,39724,1268965,1286496,1261419,1261749,1076149,1123705,94115,51713,1301395,' .
'1250758,1250767,1072637,51629,1285978,1049775,1261416,51848,1300218,1303645,51946,48761,17946,75077,88389,1042407,1079515,1079516,1133732,1104653,1085262,1089972,1089973,' .
'1095182,1120183,1105154,1092733,1105158,1095184,1131072,1197308,1210416,1210421,1095206,1079518,1089000,1089974,1095207,1111880,1112059,1120181,1263563,1111724,1092726,' .
'1111879,1320095,1095186,1320099,1095180,1210567,1297424,1297425,93510,1049678,1267742,1267746,1301387,1301955,1301956,1301957,1301958,1302264,1302267,1302268,1302278,1302279,' .
'1302958,1302959,1302265,1302266,1302271,1302272,1302273,1302274,1334015,1334016,118844,1049017,1301963,1301964,1301965,1301974,1301975,1301976,1301977,1301978,1301979,1302250,' .
'1302251,1327252,1327253,1327254,1327255,1327256,1327257,1327258,1327259,1327260,1327262,1327261,1327264,1327265,1327266,1327267,1333790,1333791,1333792,1301924,1301397,' .
'1301402,1301923,1301925,1301931,1301946,1302276,1334109,1334110,1346997,1346998,1346999,1301398,1301403,1301922,1301926,1301927,1301932,1301943,1301944,1301947,1301948,' .
'1301949,1301950,1346992,1346993,1346994,1346995,1301399,1301404,1301951,1301953,1301961,1301962,1302252,1302253,1302254,1334111,1320101,1079512,1302275,1085260,88383,1042404,' .
'1111730,1017561,1085281,1025026,1085283,1084737,1104651,1217330,1217331,1217332,1217333,1085282,1085295,1045069,1084735,1084738,1084746,1084749,1084831,1333779,1217327,' .
'1217328,1217329,1073701,1131064,1210366,1085261,1105107,1084694,1084695,1084696,1084697,1084739,1084754,1090121,1090124,1090125,1090128,1105108,1045051,1079530,1090131,' .
'1132930,1132931,1105125,1057812,1105151,1045060,1079525,1079527,1126326,1126327,1131065,1131068,1210406,1217255,1084702,1084718,1217265,1217266,1217311,1217345,1217268,' .
'1217312,1217269,1217270,1042293,1217309,1217340,1217271,1049650,1217298,1217308,1217310,1217341,1217347,1217348,1217379,1254462,1254463,1254464,1254465,1254466,1217322,' .
'1217323,1217324,1217326,1217336,1217343,1217344,1217346,1250957,1217352,1250970,1242045,1242046,1361381,1090122,1105128,1131071,1217342,1085263,1217338,1217339,1217376,' .
'1217377,1217378,1217367,1217369,1084748,1217382,1217370,1084741,1217383,1217368,1217371,1217381,1217390,1217384,1084742,1084744,1217385,1223087,1217388,1217389,1333753,' .
'1333754,1085264,1217334,1217335,1085265,1045068,1230861,1088533,1197312,1230864,1217256,1217273,1217275,1045047,1217276,1217292,1230353,1217274,1217278,1090137,1217279,' .
'1090138,1217289,1084952,1254677,1217290,1217293,1254678,1206932,1283439,1261411,1022158,98458,1090845,1217749,1217750,1161058,1309906,1064461,97851,1272185,1301216,1271186,' .
'1261853,1300224,1269174,1244440,1303646,44827,43713,51689,1055114,97303,1151063,1156336,1162546,1064482,1247187,1092953,97640,1272193,1296441,1296446,1296453,1296457,1329145,' .
'1246202,1090761,1090771,1045795,1095492,51736,1293156,95290,39834,1112096,1183305,1092754,1267594,39902,39890,39922,97220,1168240,1261854,1095464,1255278,98289,51767,1131412,' .
'1318702,1117217,1064130,1079692,1145589,44249,94104,94114,94103,94113,94229,1256702,1258184,86344,1330379,1256491,67678,1303669,17873,1290491,10043,51928,51770,1048013,' .
'1095488,1341093,51874,1275025,1275579,51907,51866,1089421,1274996,51699,1064151,1060227,74159,1131123,51771,51816,61796,69269,99698,1090088,1127303,1247155,1255381,1256347,' .
'1274301,1289364,1117129,1049780,1049776,1269151,1076591,1162866,1203543,1088598,109434,88390,109435,51894,1243678,44784,97363,1300233,1161014,98137,1209931,1245867,1224299,' .
'1284225,1330363,1063639,1288534,1168259,1057029,1223277,1068901,1255247,1117167,1191456,51750,1257802,1274298,1084878,1273660,1274294,1274695,51681,44867,1274698,67727,' .
'1274700,97974,43700,97873,49081,1052652,1075659,1255240,1111846,1274309,1136347,1207808,94220,1288336,1051182,1186720,1186730,109010,1099347,62551,1282784,1260736,1341098,' .
'1120468,1327675,1120526,1186533,44931,1076911,96988,1105283,1076913,1120226,96354,1091143,1083261,1057027,39992,1186535,62553,1325329,1240476,1011422,70419,51621,49849,51660,' .
'55260,59052,1083269,1083271,1083898,1105570,1197352,1250553,1284619,1340405,55262,59060,78126,1083257,1083279,1176204,1204599,1204596,1250789,1250790,1198649,1198650,1198654,' .
'1198658,1198660,98457,98476,98477,51666,1090069,1292043,1292045,1090075,1048971,1049031,1049033,1049035,1049036,1049037,55259,55263,55264,67995,68001,1016974,1048965,1011411,' .
'1011415,1230237,1230239,1230240,1230241,1232051,1232053,1232055,1232057,1232058,1232059,1272560,1128712,58775,76074,1254397,1316931,1221865,1221858,1221859,1221860,1221861,' .
'1221862,1221863,1221868,1321881,1235556,1235557,1235560,1235562,1235564,1235565,1235566,1235568,1235569,1235571,1235572,1235573,1241670,1235574,1128713,1235576,1235579,' .
'1272550,1272551,1272552,1272553,1283894,1128754,1283895,1283898,1283899,1283900,1283901,1283902,1283903,55317,55589,55340,55341,55346,55347,55348,55425,55429,55444,55449,' .
'97448,97453,1077257,1077258,1093115,1093118,1112917,58798,58870,58895,58916,58875,1076514,1076515,75680,75683,75686,75699,1076513,1021040,1076510,1076511,1076512,1083280,' .
'1083424,1083425,1076517,58776,59043,1076519,58792,58844,58847,58850,1076521,58900,58905,1076522,58908,58930,1076523,58944,58959,1076524,58966,58967,75713,1076531,1076532,' .
'1076533,1254342,1254345,1083281,1059918,1083282,1126574,1112926,1126575,1133814,1133815,1133816,1254348,1267889,1292037,68084,68097,1074404,68662,92052,92133,1221864,1221866,' .
'1221867,98363,98367,98416,1073716,1073717,1076540,1076541,1277144,98672,98673,98678,98682,98686,98690,1221869,1221870,1221871,1221872,1221873,1221874,1221875,1221876,1221879,' .
'1319935,1319936,59030,59047,59031,59049,62013,62016,1048555,1090812,86304,1102017,86306,86321,1102018,1321882,1321883,1321885,1321886,1321887,1321888,1321889,1321890,1321891,' .
'98612,55464,55465,55467,55470,1090841,62534,88630,88632,88636,88644,88646,108653,108658,108664,108671,108682,108695,108701,108705,1058186,1094581,1198693,1069587,1073432,' .
'1090835,1098994,1106075,1122900,1122907,1268973,1268974,1289841,69352,1084024,1090846,92206,1221884,93930,1095484,98379,1049023,1090852,1090856,1090898,1126625,1128755,' .
'1128756,1128757,1128759,1283906,1221880,1221881,1221882,1221883,1257843,1257816,1275311,1264569,1275312,1293165,109446,55293,55362,55363,59051,59111,1073995,1075877,98323,' .
'1011407,1328631,1121931,1219894,1219895,59101,59102,59103,59109,109444,1090755,1090756,1113019,59268,55475,97491,98356,1048955,1049026,1076711,1090780,1128251,1302954,1022157,' .
'1120578,1084873,1121932,1121933,1244380,1244383,1256919,1257717,1319933,1319934,1083039,59107,1072675,1083040,1134581,1219943,1230588,1049027,1230589,49597,70554,70435,70436,' .
'70440,1048950,1102954,1133230,1208130,70437,1048949,1095507,70561,1102077,1131192,1193865,1193867,1268758,1268859,1268860,1268927,70569,1048956,1084935,1099314,70562,1099315,' .
'1336468,70587,70588,71757,1001426,1268369,70989,1326812,76160,70585,1049040,1084938,1104662,1223265,1133818,1201260,1133220,1133223,76084,1133225,1133226,1093353,1237889,' .
'1237890,61849,62535,93931,1033613,98391,98445,1084869,1084870,1121934,1236470,1237891,98614,104737,1073868,1236563,1246663,1120556,1246664,1322734,1257841,1237892,1051162,' .
'1087429,1090849,1276205,1250292,1255276,1269049,1317232,1257842,1257848,76340,69372,1011390,1011392,1048957,1011395,1011398,1208125,1255722,1296367,1011399,1011406,1064122,' .
'86417,1049028,1071852,1133802,1304174,76342,76213,76214,86370,86408,1016925,1037236,1059936,1090700,1090697,1250669,1255944,76302,1074344,1074345,1074346,1074348,1074351,' .
'76304,1074353,1090699,1221857,76320,76321,1035398,86301,1037235,1049039,1228698,1296388,86425,1016924,1071851,1219910,1255939,1304191,97501,1090695,1094597,76344,1064156,' .
'1099666,1232990,1064159,1064154,1016918,1016921,1239404,1240488,1239406,1240489,1240650,1268762,1239407,1016922,1239414,1239410,1240487,1239411,1240490,1239412,1204570,' .
'1240663,1016919,86415,94320,1049029,1095476,1219902,1064125,1059930,1064126,1296334,1064134,1219906,1064139,1095474,1296137,1064145,1047242,1176203,1064147,1212360,1093140,' .
'1064148,1048953,1059844,1090702,1090704,1094585,1212359,1296385,1296386,1296397,1296398,98622,1035396,1047203,1083044,1112853,1090708,1090713,1090717,76341,1133715,1016978,' .
'1016979,1133716,75660,1240666,51937,1267731,1267732,71765,1016926,1016927,1228672,1228673,1228674,1228675,1290957,1301166,1245589,1013708,1115842,1013709,1059563,1059571,' .
'1290965,1284964,1282952,1048967,1048968,1262387,1049739,1241709,1272561,1293130,1293132,1293134,1293136,1309415,1331460,1341586,1342176,1049785,1051347,1051175,1286302,' .
'1293138,1324998,1324999,1051348,1293141,1293142,1293143,1293144,1051349,1051191,1309732,1051351,1309417,1309419,1309418,1309421,1309422,1309733,1309736,1309735,1241463,' .
'1049755,1293145,1293146,1309416,1341939,1241671,1051169,93680,94100,94101,94110,94112,94120,1327659,1123718,1327670,93987,1327673,94164,1309466,1309420,1309467,1309469,' .
'1309471,1309477,1309478,1309479,1309480,1309482,1309483,1309484,1309485,1309487,1309488,1309491,1309492,1255588,1087120,1255589,1255596,1255593,1255594,1255881,1268054,' .
'1335596,1255879,1255880,1255931,1335585,1367592,1335586,1367594,1335605,1367595,1335595,1268934,1051197,76123,1268968,1051203,1272557,1272567,1268935,1051196,1272555,1272564,' .
'1051200,1272558,1272565,1268940,1272556,1272566,1268941,1293125,1293126,1268943,1051201,1293127,1336458,1268947,1272559,1289102,1304173,1304179,1304180,1304181,1304187,' .
'1304182,1304188,1362686,70421,70422,94255,1212416,1212417,1212428,1212439,1212418,1212419,1212429,1212420,1212421,1212430,1212422,1212413,1212427,1212423,1212414,1212425,' .
'1212424,1212415,1212426,1212431,1212432,1212433,1256950,1212435,1212436,1256984,1256948,1256949,1257185,1256962,1256963,1257184,1256981,1256982,1257191,1257174,1257175,' .
'1257190,1013422,1013423,1033452,75771,75791,75807,75878,75879,75930,75931,1212400,75980,1072683,1212401,75981,1212402,75982,1072685,1212403,75983,1072686,1212404,75984,' .
'1071854,1071855,1071859,1071872,1072137,1090719,1071857,1071858,1137834,1137854,1137859,1071860,1071861,1137835,1137855,1137860,1071862,1071863,1137838,1137856,1137861,' .
'1071864,1071867,1137836,1137857,1137862,1071865,1071868,1071873,1072138,1090723,1071866,1071869,1137837,1137858,1137863,1079454,1212445,1197345,1208097,1208099,1208098,' .
'1262531,1265584,1265592,1208100,1208102,1234513,1262532,1265579,1265585,1265593,1301160,1313041,1208101,1208103,1208104,1262535,1265580,1265588,1265596,1208105,1208106,' .
'1208107,1208108,1262528,1265582,1265590,1212394,1212395,1262533,1265586,1265594,1212396,1212397,1262529,1265583,1265591,1212398,1212399,1262534,1265587,1265595,1238169,' .
'1262527,1265581,1265589,1304175,1211927,1211928,1212443,1134952,1212442,1228667,1228668,1228669,1228670,1228671,1231565,1256536,1090087,1073958,1090730,1095481,1098985,' .
'1124321,1223570,1133216,1208096,1231566,1133609,1071853,1071874,1071883,1137839,1137844,1137849,1071875,1071884,1071890,1071892,1090867,1071876,1071885,1137840,1137845,' .
'1137850,1071877,1071886,1137841,1137846,1137851,1071878,1071887,1137842,1137847,1137852,1071879,1071888,1071891,1071893,1090868,1071880,1071889,1137843,1137848,1137853,' .
'1072636,1290492,1133615,1133627,1133628,1133629,1133631,1133632,1133633,1133634,1212448,1133617,1212449,1011384,1133618,1212450,1011385,1133621,1212451,1011386,1133625,' .
'1212452,1011387,1133626,1133635,1121953,1126891,1212453,1212454,1212455,1212457,1212456,1212458,1212459,1212461,1212460,1212462,1212463,1212464,1212465,1212466,1212467,' .
'1208111,1208112,1208113,1269699,1323006,1208115,1208116,1208118,1208117,1208119,1208120,1208121,1208122,1208123,1208124,1323005,1323007,1212471,1212468,1212469,1212470,' .
'1212472,1212473,1212474,1212283,1212288,1256541,1296123,97534,99627,1035179,99628,1035180,1035181,1035183,1035184,1035185,1035186,1035187,1035188,1035193,1035198,1035199,' .
'1035200,1035201,1035202,1035203,1069566,1069567,1069568,1179342,1179343,1206902,109453,109454,1133786,1133787,1255478,1133789,1090893,1255477,1223280,1255479,1098753,1098754,' .
'1099194,1133784,1133785,1228678,1133821,1228679,1255476,1099192,1099193,1105603,1105871,1132959,1133453,1143464,1143967,1186925,1256920,1111337,1133794,99506,1228697,1264145,' .
'1264146,1264147,1264148,1293152,1336298,1370930,1370981,1373188,1111494,97064,44876,97067,1080146,1065775,1261754,1142148,1261421,1261420,1036717,1162868,1182487,1131240,' .
'1131256,1239390,1186263,1186264,1267893,1142150,1131252,1085335,1186278,1229792,1181721,1131233,1162633,1131241,1190999,1162645,95349,44883,1090847,1293166,1261873,1325327,' .
'1123532,58812,1283952,1098739,1244381,1276654,1274300,1158446,1283646,1156685,1261417,1251320,1055113,1120216,1275584,1261415,94177,94182,1229710,1123708,1277511,44888,' .
'1136352,1288217,1177455,97101,1115124,1049731,1274370,1282761,1282762,1269160,1282760,1269175,1269161,1269176,1269177,1269178,1269179,1269180,1269181,1068731,97074,1236561,' .
'1300220,1319222,1112104,51865,51864,51863,1112098,51782,1204577,51867,51872,1112099,17632,1255328,1301982,1112103,1319224,51783,1009804,1053671,1274684,1319225,51870,1204586,' .
'51679,1030207,1327660,1250780,1055115,1319215,68069,1300231,97122,1251349,94185,94186,1261413,52749,1045058,1059573,1272177,1095368,1197070,1272191,1203635,1058710,1052668,' .
'1052670,1261339,1102037,1235578,17779,1064123,1341113,1047971,1090833,1271761,1275593,1092126,1092128,1099004,1201254,1111493,1328030,76338,17442,109022,1245921,1264570,' .
'1293139,1103453,1261159,1261743,1261740,14589,1255584,1261872,1090776,1218547,1261157,1218546,1256550,1269656,1320730,1261857,1089375,46625,1136383,1136382,1136385,1136386,' .
'1136380,1136384,1136378,1136379,1274292,38114,1302255,10055,1322987,67518,1284937,41262,51727,67521,85869,93922,97086,1095499,1115293,1131151,1319599,1327665,1322988,45948,' .
'1293158,1293159,67735,1207817,97038,1271389,46643,1261412,1261166,1033607,1095505,1212412,45923,1112635,1273656,1190960,67670,44901,1274295,51871,1105288,1255882,109034,' .
'1037231,1257844,1336476,1090118,46027,1060264,1049618,1298648,49028,1144151,1139897,1181772,1296460,1046034,109046,1261867,51754,1256552,1136357,1222077,51690,51703,1269159,' .
'1122186,1261855,1102020,109058,1255387,74567,74566,1288180,1103035,74150,1256340,1256341,1288221,74151,1337539,1077577,74153,51739,1261156,97328,1256349,97326,94548,64040,' .
'1256348,67663,1120461,1112082,59061,40982,1092834,67809,1296143,1261174,51854,51694,51696,1251342,39613,38741,51688,51622,1282820,1119633,1325326,1136375,1282821,86402,' .
'1268883,1268887,1047858,51780,1201471,1274296,1141999,1064354,1269182,1277308,1064465,17473,18161,51876,1251475,1329838,1243500,1005952,51800,51803,74143,94211,94215,1123711,' .
'1123715,1229711,1123713,1123714,93702,94158,94170,94203,94207,1123710,1229712,1326510,1229705,1229706,1123712,1064464,49812,1326515,1247713,1331443,40985,1339072,1269173,' .
'1289998,1293160,1015022,1178562,1105289,67556,46705,1204421,1261874,1319410,1175019,45845,1085471,51789,1115715,1186980,44908,1103023,1275569,44910,1048048,1128758,1327658,' .
'54922,46641,59050,1089886,1112076,1121939,1224296,1301941,1255226,1255227,97385,1329947,39808,1283651,97054,1191453,1092125,1138309,61519,1324996,1267974,1092945,1256703,' .
'1042442,1267963,1268930,109070,1007653,61688,1122187,1253694,1203614,53652,1093110,1286472,1286475,1286477,1286478,1286481,1286492,1286493,1286494,1286500,1011369,1243870,' .
'1111582,1085828,1037282,51851,18635,46603,46613,1329841,1056435,1011418,1263239,1270095,1275285,1267595,1267650,1267651,1284978,1202189,1007989,1007992,1007993,1007994,' .
'1012088,1267987,1267994,1268006,1268011,1268012,1268014,1268016,1268020,58832,67645,1204571,1284013,1284015,1284020,1284021,1284213,1284220,1284228,1284229,1284234,1284235,' .
'1288333,1288344,1288348,1288360,1288387,1288392,1301350,1301352,1301357,1301396,1301409,1301934,1301935,1343481,18880,1274687,1274689,1275595,1123015,1009805,1112101,1207090,' .
'1009806,1136549,1112102,1112100,1263220,1263212,1263213,1263221,1263211,1263219,1284216,1271760,1326981,1263230,1270094,1271477,1271478,1274703,1274817,1275011,1275279,' .
'1275282,1275326,1288224,1288341,1301937,1251353,21112,1081208,1275293,1343118,1243636,1111320,1111323,1136544,1111322,1111321,45981,45965,1120829,1120839,1267960,1263214,' .
'1245846,18889,1267988,1105864,1123013,1007656,1007652,1168243,1042353,1105143,1136358,1203164,1290967,1296380,1332460,1252973,1252982,1301227,1175936,19671,96369,96985,' .
'1282774,1155872,1064894,1193859,1120259,1126556,1099417,95372,1089684,55567,14844,1049652,1085321,1330880,1343310,1207878,1250907,1251352,1251357,1309490,1080053,1201259,' .
'1201257,1093093,1263240,1204578,1057078,1339039,10006,1105899,1007248,1124345,1278104,109106,94760,1105246,1193888,1037225,1059652,1117577,1120564,1121169,1121215,1122488,' .
'1136121,1136123,1156620,1156646,1162576,1241327,1241354,1243867,1284933,1284934,1284938,1294473,1339067,1313563,1263215,1250753,1245349,1089420,46533,14312,1063644,46332,' .
'1049789,1254136,1255334,1255583,1255595,1261070,1301392,97309,49891,67755,1175026,44879,1269150,1270783,50945,1245074,40525,1330366,1330375,1298917,1098662,1282775,1193873,' .
'1007654,1102161,1328670,1239306,1257803,1241724,1158431,1072158,1239338,1239340,97403,1007655,1063648,1263216,18946,1136119,1126277,85840,41472,85854,1269917,46328,1259379,' .
'1250751,55720,55745,1238967,1245130,1245131,1260405,1245893,1065477,1081954,1254137,1261177,67709,67718,103860,1256554,1081182,20132,55188,1053648,97149,1126938,1219898,' .
'1242013,1236475,1236476,1236477,1111647,1245075,1058943,1250551,1326763,20134,1095434,96113,96134,96224,1052667,96229,1275015,1275286,1263241,1277635,1289462,63272,20157,' .
'20871,1282776,1119377,1127350,1133792,1126432,20160,1284206,1284212,1284217,1284219,1284233,1284236,1288176,1288213,1288218,1301363,1282779,94261,94266,94272,1099382,1112185,' .
'1254331,1282780,1064896,1084844,1121938,1224295,1175874,1176062,123551,1261178,1189388,1117988,1012089,1073933,1060243,1284004,1301000,1191455,1191457,1191465,1193862,1261138,' .
'1261143,1261145,1261147,1261149,1261150,1261165,1261167,1261175,1261176,1261340,1261341,1261407,1261410,1261414,1261845,1261846,1288362,1343337,1084118,58778,1185541,53650,' .
'56158,1092760,1270310,1136355,1069571,1133801,1120203,14991,1053455,1209934,63987,1251185,1088601,45197,1111834,98478,49440,1261734,1261736,1261738,1261745,1261746,1261747,' .
'1261748,1261755,1261758,1261848,1261856,1261858,1261864,1271371,1343604,1261180,1044541,1102163,1012090,1263242,1010528,1275323,97404,1007657,40589,1236471,1236472,94912,' .
'95287,1193863,1125401,1010527,1094002,1250166,1250172,1286237,1287228,1287229,89808,1084022,1162831,1162855,1162869,1162872,1162873,1162874,1162876,1162877,1162919,1176064,' .
'1231132,1243520,1285274,1328661,1328671,1328673,1329376,1329521,1332453,1337223,1076884,1076910,1105195,1105898,1119526,1125313,75676,1076529,1245851,1126880,46524,46017,' .
'97028,97329,19359,97261,1049628,40755,1049787,1007658,1085738,1245895,1245896,1081183,19380,19425,20573,20893,1007659,20628,20939,40596,1284005,44315,1337399,1258807,1254138,' .
'1204587,1084119,1302280,1284003,1284014,1284202,1284204,1284209,1284218,1284231,1284232,1288330,1288342,1288345,1288373,1288386,1288388,1288404,40620,40632,51792,97401,' .
'1174994,1247192,1251308,40959,52746,39614,1155051,1025074,1245852,1247772,20608,1051216,1018532,1051226,74485,18278,1191121,1258806,1300331,1301030,1251474,54737,21000,' .
'1081185,19769,1245853,1245855,1337400,1326766,1326765,1326767,1284201,1284227,1287982,1194153,1194432,1125400,1283784,1263235,1337660,1337658,74414,1065357,1180193,1250757,' .
'1276148,1296140,1296145,1296146,1010525,1179324,1193874,1051235,1295198,1282733,1293128,1083895,1089993,1293131,1175913,1330371,1253769,1288338,1284224,1274722,1254139,' .
'1326762,70418,70647,76076,86403,86412,86426,1011400,1133819,1269637,1037243,1209829,1058944,1219897,1219896,1303654,1303656,1303692,1303960,1303961,1303962,1303963,1309897,' .
'1309947,55478,1098975,1098977,1098989,1269037,1286066,1116432,1250844,1117779,1256330,1011389,1255245,1274676,1275565,40688,1063638,1063643,1063647,1123447,1255117,1291070,' .
'109107,1244449,1347278,1244441,1326796,1219893,1099416,44859,115028,98462,98587,1113881,1282783,1282785,1089693,1012091,38139,1008515,1234454,1243354,1082384,1082387,1012773,' .
'1134244,1048978,1092919,38377,1044544,1182258,1241337,1241353,1241428,1244444,1284939,1327744,1203634,1274667,1274699,1274701,1274706,1274819,1275020,1275029,1301942,1320010,' .
'1320011,1193891,45146,45225,10678,74494,1012068,1012069,1012095,1056434,1070197,1080896,1247195,1250738,1250750,1284215,74489,1007660,1012070,1250739,1245845,1245857,1245891,' .
'1245924,1257645,1294435,1245922,1056437,1263223,1270085,1270638,1274375,1275010,1275028,1275287,1301377,1320009,1274818,1275016,1275280,1275284,1303097,1234055,1217756,' .
'1217755,109447,59065,18339,1245856,1245859,1177445,1193998,1082883,1053649,1053650,1121022,1253161,1253764,1298840,1332455,1074156,1093112,1093126,1309738,1309739,1047959,' .
'1048041,1092783,1092944,1094172,1120248,72484,1082339,1217757,1217758,88384,1234057,1234058,1241714,1241720,1241721,1234059,1007669,1007661,40692,1060231,18944,97006,1133793,' .
'1263234,1011383,1072684,1072687,1232484,1232485,1193875,1193876,1125757,51133,96986,1193868,1263227,1254140,1207477,1139892,1139899,1175937,1176044,1176522,1332708,20270,' .
'21001,1234054,1241710,1324997,1272562,1293151,1209712,1075658,1330361,1330362,1330364,1343323,1117212,1168242,97232,1179338,1185656,67725,1133788,1133795,1257713,1186959,' .
'1094805,41218,1228680,1228682,1228699,1228700,1228701,1243326,1243328,1243331,20655,21002,1053062,38064,21363,21498,1121979,1284203,1288179,1288340,1288343,1288346,1136126,' .
'1288226,40129,1238094,1012077,1193877,1289461,1289468,1193872,1089815,1293123,1293129,1293137,48346,38206,38190,46706,67642,97400,1079693,1081196,1090089,1122566,1123016,' .
'1211844,1251355,1125758,96300,1093957,40721,40725,1112798,1290399,1037251,1093094,1254349,1254353,1267892,1268975,1268976,1268977,1267891,1267886,1267887,1267888,1309902,' .
'1193878,1220912,40729,1063815,1120586,1102168,1089142,1061707,1089317,64161,1012079,1007662,41231,1053651,1203613,1145590,1193885,1238968,1238969,1238970,1243517,1238971,' .
'1238972,1238973,1238974,64166,1250163,1037244,1093117,1094603,1094604,1286784,1337401,1330241,1112590,1247651,1094786,16621,1190959,1190996,1328029,1186268,1186275,1186276,' .
'1186279,1186534,1186547,1186549,1186550,1186551,1190954,1190958,1190961,1190973,1190993,1190995,1190998,1231133,1239204,1276668,1277631,1277633,1283905,1284022,1284037,' .
'1284047,1247649,1246987,76305,1011396,1011403,108925,1186539,1224387,1176526,19605,48782,54912,74559,74570,97002,97021,97221,97349,97402,1053659,1063642,1090091,1111316,' .
'1111331,1123012,1136898,1174999,1211845,1211905,1251336,1251354,1256329,1256343,1256344,1256346,1256399,1256401,1256485,1256489,1256492,1256553,1256701,1289274,1161018,19538,' .
'1245861,1193887,1251183,1337659,1102149,1102169,1328032,54660,1094804,45229,1257241,1256490,97240,1250845,1134245,1198656,1243548,1183188,1246609,1081189,1089443,1245854,' .
'1088396,20288,1117816,1227554,1070196,1250741,1244336,1081956,1065467,1065476,1282787,46593,1193879,15038,1194431,1149950,1193861,1193864,46617,55403,1303895,1059870,1059877,' .
'1059891,1081201,1261077,1244389,94550,46718,97056,1137797,1175028,1049642,97356,94540,1049743,1175015,1210771,1247139,96995,96999,1168244,1168251,1211903,1218754,1230355,' .
'1242520,1247229,1250786,1250908,1251337,1251343,1303648,1058267,14311,5987,1218842,1218859,1267744,1270779,1298373,1298395,1324707,1337538,1337540,1060245,1241723,1095427,' .
'1263243,1271474,1271475,1273664,1274372,1274378,1274677,1288339,1316580,93130,1274361,1275001,1275002,1261179,97330,1282788,1245865,1105242,1105284,1105295,1236478,59053,' .
'1193880,1245868,49061,1284008,1284205,1284211,1288332,1288350,1301351,1301353,1301354,1301355,1301358,1301983,1275023,1275024,1275281,1275550,1275592,1301356,1320008,1245880,' .
'1136122,1193881,109156,1229791,1229796,1229797,1229798,1229799,1283506,1283547,1283549,1337923,1337925,1337931,1229795,1073517,1284936,1263225,1330358,1343201,1235558,1117263,' .
'1083260,1275552,18499,1245871,1250555,97470,1282772,1337402,1102150,1102156,1193882,1105244,1133567,1193883,1287407,1330372,1330378,1343482,1072159,39836,97399,1119381,' .
'1250849,1296370,1296371,1289362,1360481,1360479,1296438,1360477,1360475,1360473,1329125,1296448,1296449,1296450,1296454,1080435,1329945,1193884,46548,1272172,1272176,1272178,' .
'1272184,1272186,1272192,1272194,1095479,20303,21007,67890,18505,1007664,1284016,1079428,1245873,1044750,1282789,1254328,51821,51826,1082880,19146,21217,1081198,1211242,' .
'1247194,1193869,1230474,1236474,1236480,1236483,1236486,1236558,1236560,1250289,1255236,1255238,1255241,1255277,1230473,1232983,1236482,1255250,1275586,1318787,1318789,' .
'1318833,1318834,1318835,1318837,1318838,1319204,1319205,1319206,1319209,1319212,1319213,1319218,1319219,1319228,1319229,1319230,1319408,1319409,1319411,1319412,1319413,' .
'1319414,1319416,1319418,1319586,1319587,1319588,1319589,1319590,1319593,1319595,1319598,1319603,1319608,1346133,1346363,1252979,1112591,1277296,1277298,1277300,1277302,' .
'1277306,1343355,1263238,1012078,1012087,1012093,1044841,1044851,1168241,1247197,1251187,1309493,1070198,1276763,1149333,1251346,18969,1263217,1072160,20681,21009,64144,' .
'1081190,99665,40775,51781,51892,1253192,1093125,1203636,51778,1282790,1073538,1284007,1085762,1242574,1263231,20327,67909,1245879,46526,1326764,1243353,67723,1263218,1074714,' .
'1037253,1093122,98781,1277609,19516,18529,1053654,1093121,1093114,1254329,1063917,1257155,1056440,76114,76120,76143,1051217,1058905,1058935,1058936,1105291,1245003,1245680,' .
'1203633,46379,1275009,1275019,1275021,1275022,1012080,1012082,55518,1060228,21115,1191313,1179328,1289068,1318489,1102171,1330368,1330369,1153572,46579,46556,46601,1136387,' .
'46570,1193947,1053663,1089372,1270091,1271471,1271476,1273657,1273662,1273663,1273666,1274360,1274362,1274374,1274688,1274720,1274724,1275012,1275577,1288536,1300427,1301410,' .
'1343350,1263210,1179323,1179329,1282953,1179331,1179340,1179335,1179337,1179332,1179341,1241968,1241972,21033,1062819,51828,1117216,20037,1293153,1230246,20753,21080,20741,' .
'21079,1105630,1263224,20356,1269172,1269198,1269200,1269203,1282765,1330370,1301952,1301980,1102151,1102568,1076886,1254141,1007665,1284214,1284221,1284237,1288347,1288407,' .
'1301401,1301938,1301954,1298319,76293,98464,98596,98610,1016950,1048954,1048958,1048966,1048977,1048988,1049004,1049022,1074354,1091213,1098971,1230605,1257824,1257840,19229,' .
'1250740,1303099,1060222,46939,1223250,1144066,1008532,1012094,1182726,1182792,1182812,1182826,1182828,1182829,1207818,1254330,1329195,46149,44199,1156512,1162566,1319841,' .
'1089437,1076912,58975,58968,1183421,44904,1053658,1064119,1081211,1090092,1120487,1120491,1150083,1168246,1251338,1298315,1304178,1194010,38626,1102152,1102174,1251362,' .
'1126430,1064282,1263229,88431,1256294,1330240,1330242,44895,1261140,1261168,1093096,1252980,1232486,1298316,1136120,96303,97009,18555,1194011,1282792,1282793,18556,46627,' .
'1007667,1301364,1092917,1079725,1079727,1079729,1089847,49968,1084843,1089484,1245878,1053655,1191020,1191021,1221877,1221878,1270286,1258975,1258976,1258977,1258978,1012092,' .
'1049621,1289456,1115714,1074154,1273633,1273634,1273655,1274715,1275013,1275014,1320190,1120252,46636,1225864,1047851,1089945' .
q!]}' WHERE `perf_filter_id` = 755899 AND LENGTH(`condition_json`) = 65535!);
my $condition = get_one_field_sql(PPC(shard => 8), ['SELECT `condition_json` FROM `bids_performance`', where => {perf_filter_id => 1491811}]);

$log->out({new_length => length($condition), should_be => 60839});
from_json($condition); # смотрим на FINISH: появится, если не упадёт from_json
$log->out('FINISH');
