#!/usr/bin/perl

=head1 DEPLOY
# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько минут",
      comment => "Можно перезапускать"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use my_inc '..';

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use ShardingTools qw/ppc_shards/;

use ScriptHelper;
use Settings;

use Direct::Modern;
use Moderate::ResyncQueue;


my $DELETE_CHUNK = 500;

my $priority = 0;
my $remoderate = 0;

extract_script_params(
    'shard=i' => \my $only_shard,
);

$log->out('START');

foreach my $shard (ppc_shards()) {
    if (defined($only_shard) && $only_shard != $shard) {
        next;
    }

    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out("START for shard $shard");
    my $cids = get_one_column_sql(PPC(shard => $shard), ['SELECT cid FROM moderation_cmd_queue', WHERE => {cmd => 'copyCampModerateInfo'}]);
    $log->out("fetched cids:", $cids);

    for my $cids_chunk (chunks($cids, $DELETE_CHUNK)) {
        $log->out("delete chunk of ids:", $cids_chunk);

        my $data = Moderate::ResyncQueue::get_all_objects_by(cid => $cids_chunk, priority => $priority, remoderate => $remoderate);
        $log->out("count of objects for resync_queue: ", scalar @$data);
        Moderate::ResyncQueue::mod_resync($data);

        my $deleted_cnt = do_delete_from_table(PPC(shard => $shard), 'moderation_cmd_queue', where => {cmd => 'copyCampModerateInfo', cid => $cids_chunk}) + 0;
        $log->out("deleted $deleted_cnt copyCampModerateInfo cmds");
    }
}

$log->out('FINISH');
