#!/usr/bin/perl

=head1 DEPLOY

# approved by gerdler
# .migr
{
  approved_by => 'gerdler',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "минута",
      comment => "Можно перезапускать, ссылка на файл с данными указывается в параметре --data-file. Данные лежат в ppcdev3:/home/khuzinazat/bids_no_show_moderate.txt"
    }
  ]
}

=cut

use Direct::Modern;

use my_inc '..';

use ScriptHelper;
use Settings;
use BS::ResyncQueue qw/bs_resync/;
use Yandex::DBShards;
use Yandex::Retry;
use Yandex::DBTools;

my $data_path;
extract_script_params(
    'data-file=s' => \$data_path,
);

$log->out( 'START' );
$log->out( "load bids to resume content promotion video banners from file $data_path" );
open (my $fh, '<', $data_path) or $log->die( "Error opening file: $!" );

my $bids;
my $cnt = 0;
while (my $line = <$fh>) {
    if ($line =~ m/^(\d+)$/) {
        push @$bids, $1;
        $cnt++;
    } else {
        $log->out( "invalid data line: $line" );
    }
}
close ($fh) or $log->die( "Error closing file: $!" );

$log->out( "Got $cnt bids to resume banners" );

foreach_shard bid => $bids, sub {
    my ($shard, $chunk) = @_;

    $log->out("chunk: ", $chunk);

    my $resync_data = get_all_sql(PPC(shard => $shard), ["SELECT cid, bid FROM banners", WHERE => {statusShow => 'No', bid => $chunk}]);
    $log->out( { resync_data => \@$resync_data } );

    relaxed times => 2, sub {
        my $affected = do_sql(PPC(shard => $shard), ["UPDATE banners SET statusShow = 'Yes'", WHERE => {statusShow => 'No', bid => $chunk}]);
        $log->out("updated $affected banners");

        my $rows_affected_by_resync = bs_resync($resync_data);
        $log->out( { rows_affected_by_resync => $rows_affected_by_resync } );
    };
};

$log->out('FINISH');

