#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gukserg',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "минуты",
      comment => "Можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use my_inc '..';

use Yandex::DBTools;
use ShardingTools qw/ppc_shards/;
use Settings;
use ScriptHelper;

$log->out('START');

foreach my $shard (ppc_shards()) {
    $log->out("Processing shard $shard");

    my $bids;
    do {
        $bids = get_one_column_sql(PPC(shard => $shard), [
            'select b.bid from banners b join banners_performance bp on b.bid = bp.bid join perf_creatives pc on pc.creative_id = bp.creative_id',
            WHERE => {
                'pc.creative_type'      => 'performance',
                'b.statusModerate'      => 'Sent',
                'pc.statusModerate__in' => [ 'Yes', 'No', 'New', 'Error' ]
            },
            LIMIT => 500
        ]);
        $log->out("Fetched bids:", $bids);

        if (@$bids) {
            $log->out("Updating bids");
            my $updated = do_update_table(PPC(shard => $shard), 'banners', {statusModerate => 'Yes'},
                where => {
                    bid__in        => $bids,
                    statusModerate => 'Sent'
                }
            );
            $log->out("Banners updated $updated");
        }
    } while (@$bids);
}

$log->out('FINISH');
