#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gukserg',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "минуты",
      comment => "Можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use my_inc '..';

use Yandex::DBTools;
use ShardingTools qw/ppc_shards/;
use Settings;
use ScriptHelper;

$log->out('START');

foreach my $shard (ppc_shards()) {
    $log->out("Processing shard $shard");

    my $pids;
    do {
        $pids = get_one_column_sql(PPC(shard => $shard), [
            'select p.pid from phrases p join campaigns c on p.cid = c.cid',
            WHERE => {
                'c.type' => 'performance',
                'p.statusModerate__in' => [ 'Ready', 'Sending', 'Sent' ]
            },
            LIMIT => 500
        ]);
        $log->out("Fetched pids:", $pids);

        if (@$pids) {
            $log->out("Updating phrases");
            my $updated = do_update_table(PPC(shard => $shard), 'phrases', {statusModerate => 'Yes'},
                where => {
                    pid__in => $pids,
                    statusModerate__in => [ 'Ready', 'Sending', 'Sent' ]
                }
            );
            $log->out("Phrases updated: $updated");
        }
    } while (@$pids);
}

$log->out('FINISH');
