#!/usr/bin/perl

=head1 DEPLOY
# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько минут",
      comment => "Можно перезапускать. Проставляет statusModerate=Yes для зависших на модерациии объектов внутренней рекламы"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use strict;
use warnings;
use my_inc '..';

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use ShardingTools qw/ppc_shards/;

use ScriptHelper;
use Settings;


our $KEY_BY_TABLE = {
    'campaigns' => 'cid',
    'phrases'   => 'pid',
    'banners'   => 'bid',
};

my $UPDATE_CHUNK = 500;

extract_script_params(
    'shard=i' => \my $only_shard,
);

$log->out('START');

foreach my $shard (ppc_shards()) {
    if (defined($only_shard) && $only_shard != $shard) {
        next;
    }

    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out("START for shard $shard");

    my $campaign_ids = get_one_column_sql(PPC(shard => $shard), [ 'SELECT cid FROM campaigns join campaigns_internal using(cid)', WHERE => { statusModerate => 'Ready' } ]);
    $log->out("fetched campaign_ids:", $campaign_ids);
    update_statusModerate_for_table('campaigns', $shard, $campaign_ids);

    my $adgroup_ids = get_one_column_sql(PPC(shard => $shard), [ 'SELECT pid FROM phrases join adgroups_internal using(pid)', WHERE => { statusModerate__in => [ 'Ready', 'Sending' ] } ]);
    $log->out("fetched adgroup_ids:", $adgroup_ids);
    update_statusModerate_for_table('phrases', $shard, $adgroup_ids);

    my $banner_ids = get_one_column_sql(PPC(shard => $shard), [ 'SELECT bid FROM banners join banners_internal using(bid)', WHERE => { statusModerate__in => [ 'Ready', 'Sending' ] } ]);
    $log->out("fetched banner_ids:", $banner_ids);
    update_statusModerate_for_table('banners', $shard, $banner_ids);
}

$log->out('FINISH');


sub update_statusModerate_for_table {
    my ($table, $shard, $ids) = @_;

    my $table_key = $KEY_BY_TABLE->{$table};
    for my $ids_chunk (chunks($ids, $UPDATE_CHUNK)) {
        $log->out("update chunk of ids:", $ids_chunk);

        my $updated_cnt = do_update_table(PPC(shard => $shard), $table, { statusModerate => 'Yes' }, where => { $table_key => $ids_chunk });
        $log->out("updated $updated_cnt $table");
    }
}
