#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gerdler',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "меньше минуты",
      comment => "скрипт можно перезапускать"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;
use BS::ResyncQueue qw/bs_resync/;

my $technical_counters = [
    51446871,53911873,50213458,51533966,65446441,47160534,56625499
];
my %technical_counters_map = map { $_ => 1 } @$technical_counters;

$log->out('START');

my $cids = get_one_column_sql(PPC(shard => 'all'), [ "SELECT distinct cid FROM metrika_counters", WHERE => { metrika_counter => $technical_counters } ]);
foreach_shard cid => $cids, sub {
    my ($shard, $chunk) = @_;
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
    $log->out("chunk: ", $chunk);

    # обновляем camp_metrika_counters, имеющие счетчики кроме технических
    my @cids_to_delete;
    my $updated_cnt = 0;
    foreach my $cid (@$chunk) {
        do_in_transaction {
            my $campaign_counters_str = get_one_field_sql(PPC(shard => $shard), ["select metrika_counters from camp_metrika_counters",
                WHERE => {cid => $cid}, 'for update']);
            return if !defined $campaign_counters_str;
            $log->out("camp metrika counters for cid $cid: $campaign_counters_str");
            my $new_counters_str = join ',', grep {!exists $technical_counters_map{$_}} split ',', $campaign_counters_str;
            if ($new_counters_str eq '') {
                push @cids_to_delete, $cid;
            } else {
                $updated_cnt += do_update_table(PPC(shard => $shard), 'camp_metrika_counters', {metrika_counters => $new_counters_str},
                    where => { cid => $cid} );
            }
        }
    }
    $log->out("updated $updated_cnt camp_metrika_counters");
    $log->out("cids to delete: @cids_to_delete");

    # удаляем из camp_metrika_counters записи, в которых только тех. счетчики
    my $affected = do_delete_from_table(PPC(shard => $shard), 'camp_metrika_counters',
        where => { cid => \@cids_to_delete }) + 0;
    $log->out("deleted $affected camp_metrika_counters");

    # удаляем metrika_counters с тех. счетчиком
    $affected = do_delete_from_table(PPC(shard => $shard), 'metrika_counters',
        where => { cid => $chunk, metrika_counter => $technical_counters }) + 0;
    $log->out("deleted $affected metrika_counters");

    # обновляем lastChange у кампаний
    $affected = do_update_table(PPC(shard => $shard), 'campaigns', { LastChange__dont_quote => 'NOW()' },
        where => { cid => $chunk }) + 0;
    $log->out("updated $affected campaigns");

    # переотправляем в БК
    my $rows_affected_by_resync = bs_resync([map { { cid => $_} } @$chunk]);
    $log->out({ rows_affected_by_resync => $rows_affected_by_resync });
};

$log->out('FINISH');
