#!/usr/bin/perl

=head1 DEPLOY

# approved by
# .migr
{
  approved_by => 'kozobrodov',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1-2 секунды на шард",
      comment => "Можно перезапускать. Можно запустить для нужного шарда --shard=12"
    }
  ]
}

=cut

use strict;
use warnings;

use my_inc '..';

use ScriptHelper;
use Settings;
use BS::ResyncQueue qw/bs_resync/;
use ShardingTools qw/ppc_shards/;
use Yandex::DBTools;

extract_script_params(
    'shard=i' => \my $only_shard,
);

$log->out('START');

foreach my $shard (ppc_shards()) {
    if (defined($only_shard) && $only_shard != $shard) {
        next;
    }

    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out("START for shard $shard");

    my $campaign_ids = get_one_column_sql(PPC(shard => $shard), [
        'SELECT cid FROM campaigns JOIN campaigns_internal USING(cid)',
        WHERE => { attribution_model__ne => 'last_significant_click' }
    ]);
    $log->out({ "fetched campaign_ids:" => $campaign_ids });

    my $updated_cnt = do_update_table(PPC(shard => $shard), 'campaigns',
        { attribution_model => 'last_significant_click' },
        where => { 'cid' => $campaign_ids }
    );
    $log->out("updated $updated_cnt count");

    my $resync_data = [ map {{ cid => $_ }} @$campaign_ids ];
    $log->out({ resync_data => $resync_data });
    my $rows_affected_by_resync = bs_resync($resync_data);
    $log->out({ rows_affected_by_resync => $rows_affected_by_resync });
}

$log->out('FINISH');
