#!/usr/bin/perl

=head1 DEPLOY

# approved by
# .migr
{
  approved_by => 'kozobrodov',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1-2 секунды на шард",
      comment => "Можно перезапускать. Можно запустить для нужного шарда --shard=12"
    }
  ]
}

=cut

use strict;
use warnings;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;
use Yandex::DBTools;

extract_script_params(
    'shard=i' => \my $only_shard,
);

$log->out('START');

my $email_to_update = 'banana-direct-alert@yandex-team.ru';

foreach my $shard (ppc_shards()) {
    if (defined($only_shard) && $only_shard != $shard) {
        next;
    }

    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out("START for shard $shard");

    my $campaign_ids = get_one_column_sql(PPC(shard => $shard), [
        'SELECT cid FROM camp_options JOIN campaigns_internal USING(cid)',
        WHERE => { email__ne => $email_to_update }
    ]);
    $log->out({ "fetched campaign_ids:" => $campaign_ids });

    my $updated_cnt = do_update_table(PPC(shard => $shard), 'camp_options',
        { email => $email_to_update, money_warning_value => 10 },
        where => { 'cid' => $campaign_ids }
    );
    $log->out("updated $updated_cnt count");
}

$log->out('FINISH');
