#!/usr/bin/perl

=head1 DEPLOY
# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько минут",
      comment => "Запустить скрипт с указанными параметрами: /var/www/ppc.yandex.ru/deploy/20201201_remove_spam_objects_from_moderation_queues.pl --from-date='2020-11-30'
                  Скрипт можно перезапускать, --from-date — обязательный параметр"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use my_inc '..';

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use ShardingTools qw/ppc_shards/;

use ScriptHelper;
use Settings;

use Direct::Modern;
use Moderate::ResyncQueue;


my $DELETE_CHUNK = 500;

my $priority = 0;
my $remoderate = 0;

extract_script_params(
    'shard=i' => \my $only_shard,
    'from-date=s' => \my $from_date
);

$log->out('START');

foreach my $shard (ppc_shards()) {
    if (!defined($from_date)) {
        die "from_date must be specified"
    }
    if (defined($only_shard) && $only_shard != $shard) {
        next;
    }

    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out("START for shard $shard");

    my $client_ids = get_one_column_sql(PPC(shard => $shard), 'SELECT ClientID FROM users WHERE statusBlocked = "Yes" and LastChange > ?', $from_date);
    $log->out("fetched clients:", $client_ids);

    for my $client (@$client_ids){
        my $cids = get_one_column_sql(PPC(shard => $shard), 'SELECT cid FROM campaigns WHERE ClientID = ?', $client);

        for my $cids_chunk (chunks($cids, $DELETE_CHUNK)) {
            $log->out("delete chunk of ids:", $cids_chunk);

            # объекты из ленивой подсыпаются в основную, поэтому сначала удаляем из ленивой
            my $data = Moderate::ResyncQueue::get_all_objects_by(cid => $cids_chunk, priority => $priority, remoderate => $remoderate);
            $log->out("count of possible objects in resync_queue: ", scalar @$data);
            my $ids_to_delete = map { $_->{id} } @$data;
            my $deleted_from_lazy = do_delete_from_table(PPC(shard => $shard), 'mod_resync_queue', where => {object_id => $ids_to_delete}) + 0;
            $log->out("deleted $deleted_from_lazy from lazy queue");

            my $deleted_from_export = do_delete_from_table(PPC(shard=>$shard), 'mod_export_queue', where => {cid => $cids_chunk}) + 0;
            $log->out("deleted $deleted_from_export export queue");

            my $deleted_from_cmd = do_delete_from_table(PPC(shard => $shard), 'moderation_cmd_queue', where => {cid => $cids_chunk}) + 0;
            $log->out("deleted $deleted_from_cmd cmds");
        }
    }
}

$log->out('FINISH');
