#!/usr/bin/perl

=head1 DEPLOY
# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "минута",
      comment => "Проставляет statusShow=Yes для ошибочно отключенных баннеров по предоставленному списку bid"
    }
  ],
  approved_by => 'pavelkataykin'
}
=cut

use strict;
use warnings;
use my_inc '..';

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use ScriptHelper;
use Settings;
use Path::Tiny;


# Для простоты шард захардкодим
my $CLIENT_SHARD = 1;
my $UPDATE_CHUNK = 500;

$log->out('START');

# Выбираем айдишники из файла
my @lines = path($ARGV[0])->lines_utf8();
my @bids = ();
for my $line (@lines) {
    chomp $line;
    push @bids, $line;
}

# Бъём их по чанкам и обновляем везде statusShow
for my $bids_chunk (chunks(\@bids, $UPDATE_CHUNK)) {
    $log->out("update chunk of ids:", $bids_chunk);

    my $updated_cnt = do_update_table(PPC(shard => $CLIENT_SHARD), 'banners', { statusShow => 'Yes', statusBsSynced => 'No' }, where => { 'bid' => $bids_chunk });
    $log->out("updated $updated_cnt banners");
}

$log->out('FINISH');
