#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "15 секунд на всех шардах на devtest, на проде скорее всего будет больше",
      comment => "перезапускать можно. но надо следить, чтобы клиенты с фичей tgo_all_interests_in_user_profile синхронизованы были со скриптом"
    }
  ],
  approved_by => 'yukaba'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use JSON qw/from_json to_json/;

use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use Settings;

$log->out('START');
foreach my $shard (ppc_shards()) {

# Выбираем такие condition_json которые в текстовых кампаниях и не у клиентов [64295429, 64575826] - так как у них включена
# фича, разрешающая такие действия. Также у которых interest_type == "all"
  my $ret_conds = get_one_column_sql(PPC(shard => $shard), ["select rc.ret_cond_id 
    from retargeting_conditions rc 
    join bids_retargeting br on br.ret_cond_id=rc.ret_cond_id 
    join campaigns c on c.cid=br.cid", 
    where => {
      'c.type'=>"text", 
      'c.ClientID__not_in'=>[64295429, 64575826], 
      'rc.condition_json__like'=>'%"interest_type":"all"%'},
    limit => 10
    ]);

    foreach my $ret_cond_id (@$ret_conds) {
      my $ret_cond = get_one_field_sql(PPC(shard => $shard), ["select condition_json from retargeting_conditions",
        where =>{'ret_cond_id' => $ret_cond_id}]);
      my $has_changes = 0;
      my $ret_conds_value = from_json($ret_cond);

      $log->out(sprintf("shard: %d, ret_cond_id: %d, old_value: %s", $shard, $ret_cond_id, $ret_cond));

      foreach my $value (@$ret_conds_value) {
        next if !defined $value || ref $value ne 'HASH';

        if (($value->{interest_type} || "") eq "all") {
          $value->{interest_type} = "short-term";
          $has_changes = 1;
        }
      }
      if ($has_changes) {
        my $new_value = to_json($ret_conds_value);
        do_update_table(PPC(shard => $shard), "retargeting_conditions", {"condition_json" => $new_value}, 
          where => {"ret_cond_id" => $ret_cond_id});
        $log->out(sprintf("shard: %d, ret_cond_id: %d, new_value: %s", $shard, $ret_cond_id, $new_value));
        $has_changes = 0;
      }
    }
}
$log->out('FINISH');

