#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    { type => 'script',
      when => 'after',
      time_estimate => "5 секунд",
      comment => ""
    }
  ],
  approved_by => 'ppalex'
}

=cut

use Direct::Modern;

use my_inc '..';

use ScriptHelper;
use Models::AdGroup qw//;
use Models::Banner qw//;
use ScriptHelper 'Yandex::Log' => 'messages';



$log->out('START');

sub delete_groups {
  my ($CID, @PIDS) = @_;
  $log->out("args: cid=$CID pids=@PIDS");
	
  my $banners = Models::Banner::get_banners_for_delete({pid => \@PIDS});
  $log->out("selected bids to delete " . join ",", map { $_->{bid} } @$banners);

  my ($qty, $error) = Models::Banner::delete_banners($CID, $banners, {skip_checks => 1});
  $log->out("delete $qty banners");
  $log->out("was errors $error") if $error;

  my $aerror = Models::AdGroup::delete_groups([map { { cid => $CID, pid => $_ } } @PIDS]);
  $log->out("was errors $aerror") if $aerror;
  $log->out("delete adgroups");
}

delete_groups(35479322, (3377900277));
delete_groups(35835719, (3394568375));
delete_groups(34510495, (3301760736));
delete_groups(33930554, (3390851120));
delete_groups(35818126, (3398015077));
delete_groups(36134408, (3417076962));
delete_groups(36307083, (3425964824, 3425964825, 3425964826));


$log->out('FINISH');
