#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'pe4kin',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "меньше минуты",
    }
  ]
}

=cut

=pod

    yt --proxy hahn read-table --table //home/direct/tmp/right_request_id_of_autopayments --format '<columns=[wallet_cid;RequestID]>schemaful_dsv' > /var/www/beta.ppalex.9600/deploy/20220617_restore_orverflowed_request_id.data

=cut

use Direct::Modern;

use Path::Tiny;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

my $BAD_ID = 4294967295;

$log->out('START');

$log->out("load data from file");
my @lines = path(my_inc::path('20220617_restore_orverflowed_request_id.data'))->lines({chomp => 1});

my %wallet2request;

for my $line (@lines) {
    next unless $line =~ /^\d/;

    my ($cid, $request_id) = split /\t/, $line;
    $wallet2request{$cid} = $request_id;
}

$log->out("got " . scalar(keys %wallet2request) . " wallets from file");

foreach_shard cid => [keys %wallet2request], sub {
    my ($shard, $chunk) = @_;
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
    $log->out(["processing wallets chunk", $chunk]);

    my $wallets = get_one_column_sql(PPC(shard => $shard), [ "SELECT wallet_cid FROM wallet_payment_transactions", WHERE => { wallet_cid => $chunk, request_id => $BAD_ID } ]);
    for my $wcid (@$wallets) {
        my $right = $wallet2request{$wcid};
        my $res = do_update_table(PPC(shard => $shard), 'wallet_payment_transactions', { request_id => $right }, where => { request_id => $BAD_ID, wallet_cid => $wcid });
        $log->out("changed RequestID for wallet_cid $wcid from $BAD_ID to $right. updated $res rows");
        if ($res + 0 > 0) {
            delete $wallet2request{$wcid};
        }
    }
};

$log->out({unprocessed_data => \%wallet2request});

$log->out('FINISH');

