# новая таблица записи "свобод" агентство-клиент
# база: PPC
# выполнять до выкладки

create table agency_client_relations (
    agency_client_id int NOT NULL default 0,
    client_client_id int NOT NULL default 0,
    PRIMARY KEY (agency_client_id, client_client_id)
);

# заполняем старыми привязками агентство-клиент
insert into agency_client_relations (agency_client_id, client_client_id)
select distinct ag.ClientID, cl.ClientID
from campaigns c
  join users ag on c.AgencyUID = ag.uid
  join users cl on c.uid = cl.uid
where c.AgencyUID > 0
  and c.statusEmpty = 'No';

# on devtest DB:
# Query OK, 54697 rows affected (2 min 2.36 sec)
# Records: 54697  Duplicates: 0  Warnings: 0
