#!/usr/bin/perl -w

#
# Скрипт обновляет шаблоны писем для задачи оплаты кампаний с блокировками
#
# Запустить нужно сразу после обновления программного кода (либо сразу после перезапуска сервера)
#
# Для обновления необходимо запустить скрипт -
# cd /var/www/ppc.yandex.ru/deploy/ && perl ./20100126_update_mail_templates_pay_with_block.pl
#

use strict;

use lib '../protected/';

use Settings;
use DBTools;
use Tools;

use Data::Dumper;
my $hash = {};

use utf8;

$hash = {
    name => 'notify_order_money_in',
    subj => 'Яндекс.Директ/Поступила оплата за кампанию N[% cid %]',
    content => 'Здравствуйте, [% client_fio %]!

На Ваш счет поступила оплата за кампанию N[% cid %] ([% camp_name %]) в размере [% sum_payed %] у.е. [% IF pay_type == "with_block" %]На данный момент кампания ожидает модерации и денежные переносы с или на нее невозможны.
В случае принятия кампании модератором она[% ELSE %]Кампания[% END %] [% IF in_future || pay_type == "with_block" %]начнет показы[% ELSE %]запущена[% END %] в соответствии с указанной в параметрах кампании датой старта ([% start_time %]) и настройками временного таргетинга.

Изменить дату старта Вы можете здесь: http://direct.yandex.ru/registered/main.pl?cmd=editCamp&cid=[% cid %] .

В случае отклонения вашей кампании модератором вы сможете вносить изменения в кампанию и отправлять ее на модерацию повторно в течение 36 часов. Если кампания не будет принята модератором по истечении данного срока, средства будут сняты со счета кампании Яндекс.Директ и возвращены на ваш счет в Яндекс.Деньгах в течение двух рабочих дней с этого момента.

Полный список кампаний:
http://direct.yandex.ru/registered/main.pl

-- 
С уважением,
Отдел продаж компании "Яндекс"
support@direct.yandex.ru
http://www.yandex.ru

Наши телефоны (по будням с 9.00 до 19.00):
По всей России: 8 800 333-96-39 (звонок из регионов России бесплатный)
В Москве: +7 (495) 739-22-22
В Санкт-Петербурге: +7 (812) 633-36-00
В Екатеринбурге: +7 (343) 385-01-00
факс: +7 495 739-70-70',
};

_update_templ($hash);

$hash = {
    name => 'notify_order_money_out_blocking',
    subj => 'Яндекс.Директ/Произведен возврат средств с кампании N[% cid %]',
    content => 'Здравствуйте, [% fio %]!

Ваша кампания №[% cid %] ([% camp_name %]) не была принята модератором в течение 36 часов после оплаты. Средства были сняты со счета кампании и будут возвращены на ваш счет Яндекс.Денег в течение двух рабочих дней.

Сумма остатка на кампании: [% sum %] y.e.


-- 
С уважением,
Отдел продаж компании "Яндекс"
support@direct.yandex.ru
http://www.yandex.ru

Наши телефоны (по будням с 9.00 до 19.00):
По всей России: 8 800 333-96-39 (звонок из регионов России бесплатный)
В Москве: +7 (495) 739-22-22
В Санкт-Петербурге: +7 (812) 633-36-00
В Екатеринбурге: +7 (343) 385-01-00
факс: +7 495 739-70-70',
};

_update_templ($hash);

=pod
=cut

_update_templ({
    name => 'notify_order_money_out_blocking_sms',
    subj => 'Директ: произведен возврат средств [% sum_payed %] у.е. с заказа  N[% cid %] на счет в Яндекс.Деньгах',
    content => '',
});

sub _update_templ
{
    my $hash = shift;
    
    my $tt = get_one_line_sql(PPCDICT, "select * from mail_templates where name = ? order by ttid desc limit 1", $hash->{name});
    
    if ($tt) {
        my $hs = md5_hex_utf8(join(",", $tt->{subj}, $tt->{content}));
        my $hs2 = md5_hex_utf8(join(",", $hash->{subj}, $hash->{content}));
        
        if ($hs ne $hs2) {
            warn Dumper{updated => $hash, tt => $tt, hs => $hash};
            
            return do_sql(PPCDICT, "update mail_templates set subj = ?, content = ? where ttid = ?", $hash->{subj}, $hash->{content}, $tt->{ttid});
        }
    } else {
        warn Dumper{inserted => $hash};
        
        return do_sql(PPCDICT, "insert into mail_templates set name = ?, subj = ?, content = ?, description = ?", $hash->{name}, $hash->{subj}, $hash->{content}, $hash->{subj});
    }
}
