# параметры клиента у агентства: описание клиента и статус архивации
# база: PPC
# выполнять: до выкладки в любое время

alter table agency_client_relations
  add bind enum('Yes', 'No') not null default 'Yes',
  add client_archived enum('No', 'Yes') not null default 'No',
  add client_description TEXT;

# on devtest DB:
# Query OK, 62550 rows affected (1.40 sec)
# Records: 62550  Duplicates: 0  Warnings: 0

# ----------------------------------------------------------
# заполняем старыми описаниями клиентов
# выполнять: перед выкладыванием

insert into agency_client_relations (agency_client_id, client_client_id, client_description)
select ag.ClientID, cl.ClientID, cl.description
from campaigns c
  join users ag on c.AgencyUID = ag.uid
  join users cl on c.uid = cl.uid
where c.AgencyUID > 0
  and c.statusEmpty = 'No'
on duplicate key update
  client_description = values(client_description);

# on devtest DB:
# Query OK, 6953 rows affected (28.80 sec)
# Records: 140152  Duplicates: 3476  Warnings: 0

# ----------------------------------------------------------
# заполняем старыми статусами statusArch субклиентов
# выполнять: перед выкладыванием

insert into agency_client_relations (agency_client_id, client_client_id, client_archived)
select ag.ClientID, cl.ClientID, 'Yes'
from campaigns c
  join users ag on c.AgencyUID = ag.uid
  join users cl on c.uid = cl.uid
where c.AgencyUID > 0
  and c.statusEmpty = 'No'
  and cl.statusArch = 'Yes'
on duplicate key update
  client_archived = values(client_archived);

# on devtest DB:
# Query OK, 58210 rows affected (5.40 sec)
# Records: 48216  Duplicates: 29105  Warnings: 0

# ----------------------------------------------------------
# очищаем users.statusArch для субклиентов без менеджерских кампаний
# выполнять: после выкладывания

perl /var/www/ppc.yandex.ru/protected/maintenance/fix_users_statusArch_for_pure_subclients.pl
