#!/usr/bin/perl

#
# Скрипт переносит данные из таблицы ppc.users_units поля units в таблицу monitor.api_users_units_consumption поле daily_units
#
# Запустить нужно до обновления программного кода, строго после 20100721_create_api_units_consumption.sql,
# строго до 20100723_drop_users_units_in_ppc.sql 
# (время выполнения ~ 5 сек)
#
# Для обновления необходимо запустить скрипт -
# perl /var/www/ppc.yandex.ru/deploy/20100722_update_api_users_units.pl
#


use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use DBTools;

my $units = get_all_sql(PPC, "select uid, units, scheme from users_units where uid>0");

my $values;

foreach (@{$units}) {

    push @{$values}, [$_->{uid}, $_->{units}, $_->{scheme}];

}

do_mass_insert_sql(MONITOR, 'insert into api_users_units_consumption (uid, daily_units, scheme) values %s', $values);
