#!/usr/bin/perl -w
# нужно выполнить на сервере ppc после выкладки
# примерное время выполнения: 10 секунд
# /var/www/ppc.yandex.ru/deploy/20100802_script_fill_geo_regions_types.pl

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use geobase;
use Settings;
use DBTools;

my @regions = sort {$a <=> $b} keys %geobase::Region;

my $dbh = connect_db(PPC);

while(my @chunk = splice(@regions, 0, 100)) {
    my $CASE_SQL = "CASE region_id ".join(" ", map {"WHEN $_ THEN ".$dbh->quote($geobase::Region{$_}{type})} @chunk)." ELSE type END";
    my $SQL = "UPDATE geo_regions SET type = $CASE_SQL WHERE region_id IN (".join(",", @chunk).")";
    for my $dbname (PPC, PPCDICT) {
        do_sql($dbname, $SQL);
    }
}
