# Создать таблицу users_api_options
# база данных: ppc
# выполнять: до выкладки
# примерное время выполнения: 0 сек

CREATE TABLE `users_api_options` (
  `uid` bigint(20) unsigned NOT NULL,
  `api_enabled` enum('Yes','No','Default') NOT NULL default 'Default',
  `api_offer` enum('accepted','rejected') NOT NULL default 'rejected',
  `api_units_factor` double default '1',
  `advq_queries_lim` int default NULL COMMENT 'Number of single advq queries which are allowed to user daily',
  `allow_create_subclients` enum('Yes', 'No') default 'No' COMMENT 'Allow to create new users through API for agencies and managers',
  `api_allowed_ips` varchar(255) default NULL,
  PRIMARY KEY  (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Скопировать данные из users_options в users_api_options
# база данных: ppc
# выполнять: до выкладки
# примерное время выполнения: ~25 сек

insert ignore into users_api_options (uid, api_enabled, api_offer, api_units_factor) 
    select uid, api_enabled, api_offer, api_units_factor from users_options;