#!/usr/bin/perl

# порядок действий:
# 1. выложить пакеты на ppc
# 2. запустить с сервера ppc скрипт /var/www/ppc.yandex.ru/deploy/20101108_add_client_id_for_addresses.pl (работает около 7 мин)
# 3. выложить пакеты везде
# 4. запустить (уже второй раз) скрипт /var/www/ppc.yandex.ru/deploy/20101108_add_client_id_for_addresses.pl на ppc
#
# на devtest выполняется: 39.69s user 7.88s system 11% cpu 7:07.31 total

=head1 DESCRIPTION

  добавляем ClientID в addresses

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use DBTools;
use Yandex::Log;
use Yandex::HashUtils;

use Data::Dumper;

#-----------------------------------------------------------
sub main
{
    my $log = new Yandex::Log(log_file_name => "20101108_add_client_id_for_addresses.log");

    do_sql(PPC, "SET SESSION group_concat_max_len = 1000000");

    my $all_addresses = get_all_sql(PPC, "select address_id
                                                 , GROUP_CONCAT(distinct u.ClientID) as ClientIDs
                                          from users u
                                            join vcards vc on u.uid = vc.uid
                                            join addresses on vc.address_id = addresses.aid
                                          where address_id > 0
                                            and addresses.ClientID = 0
                                            and u.ClientID > 0
                                          group by address_id
                                          -- limit 10
                                         ");
    $log->out("addresses_count = " . scalar(@$all_addresses));

    for my $row (@$all_addresses) {
        $log->out("ADDRESS: $row->{address_id} / ClientIDs: $row->{ClientIDs}");

        my @clients = split /,/, $row->{ClientIDs};
        my $old_address_id = $row->{address_id};

        my $is_first_client = 1;
        for my $ClientID (@clients) {

            if ($is_first_client) {
                # для первого (или одного) клиента просто апдейтим ClientID
                my $cnt = do_sql(PPC, "update addresses
                                       set ClientID = ?
                                       where aid = ?
                                         and ClientID = 0
                                      ", $ClientID, $old_address_id);
                $log->out({ClientID => $ClientID, address_id => $old_address_id, updated_cnt => $cnt});
                $is_first_client = 0;
            } else {

                # если адрес у нескольких клиентов, то копируем
                my $address = get_one_line_sql(PPC, "select * from addresses where aid = ?", $old_address_id);
                unless ($address) {
                    $log->out("ERROR: address not found for aid = $old_address_id");
                    next;
                }

                # для остальных клиентов вставляем новый адрес и апдейтим vcards.address_id
                my $new_addresses_row = hash_cut $address, qw/map_id map_id_auto address ahash kind precision/;
                $new_addresses_row->{ClientID} = $ClientID;
                my $new_address_id = do_insert_into_table(PPC, 'addresses', $new_addresses_row);

                unless ($new_address_id) {
                    $log->out("ERROR: not insert new addresses for ClientID = $ClientID / old_address_id = $old_address_id");
                    next;
                }

                my $vcard_id_for_update = get_one_column_sql(PPC, "select distinct vcard_id
                                                                   from vcards
                                                                     join users using(uid)
                                                                   where ClientID = ?
                                                                     and address_id = ?
                                                                  ", $ClientID, $old_address_id);
                unless ($vcard_id_for_update) {
                    $log->out("ERROR: vcard not found for aid = $old_address_id / ClientID = $ClientID");
                    next;
                }

                my $cnt = do_update_table(PPC, 'vcards', {address_id => $new_address_id}, where => {vcard_id => $vcard_id_for_update});
                $log->out({ClientID => $ClientID, old_address_id => $old_address_id, updated_cnt => $cnt, vcard_id_for_update => $vcard_id_for_update, new_address_id => $new_address_id});
            }
        }
    }
}

#-----------------------------------------------------------
main();
